/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.cmd;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.basex.core.Perm;
import org.basex.core.Text;
import org.basex.core.cmd.AInfo;
import org.basex.core.parse.CmdBuilder;
import org.basex.core.parse.Commands;
import org.basex.data.MetaData;
import org.basex.util.Performance;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.list.StringList;

public final class InfoDB
extends AInfo {
    public static final SimpleDateFormat DATE = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");

    public InfoDB() {
        super(Perm.READ, true, new String[0]);
    }

    @Override
    protected boolean run() throws IOException {
        boolean create = this.context.user.has(Perm.CREATE);
        this.out.print(InfoDB.db(this.context.data().meta, false, true, create));
        return true;
    }

    @Override
    protected boolean databases(StringList db) {
        db.add("");
        return true;
    }

    public static String db(MetaData meta, boolean bold, boolean index, boolean create) {
        TokenBuilder tb = new TokenBuilder();
        String header = (bold ? new TokenBuilder().bold().add(37).norm().toString() : "%") + Text.NL;
        tb.addExt(header, Text.DB_PROPS);
        InfoDB.format(tb, Text.NAME, meta.name);
        InfoDB.format(tb, Text.SIZE, Performance.format(meta.dbsize()));
        InfoDB.format(tb, Text.NODES, Integer.toString(meta.size));
        InfoDB.format(tb, Text.DOCUMENTS, Integer.toString(meta.ndocs));
        int b = meta.path != null ? meta.binaries().descendants().size() : 0;
        InfoDB.format(tb, Text.BINARIES, Integer.toString(b));
        InfoDB.format(tb, Text.TIMESTAMP, Util.formatDate(new Date(meta.dbtime()), DATE));
        if (meta.corrupt) {
            tb.add(' ' + Text.DB_CORRUPT + Text.NL);
        }
        tb.add(Text.NL).addExt(header, Text.RES_PROPS);
        if (create && !meta.original.isEmpty()) {
            InfoDB.format(tb, Text.INPUT_PATH, meta.original);
        }
        if (meta.filesize != 0L) {
            InfoDB.format(tb, Text.INPUT_SIZE, Performance.format(meta.filesize));
        }
        InfoDB.format(tb, Text.TIMESTAMP, Util.formatDate(new Date(meta.time), DATE));
        InfoDB.format(tb, Text.ENCODING, meta.encoding);
        InfoDB.format(tb, Text.WS_CHOPPING, Util.flag(meta.chop));
        if (index) {
            tb.add(Text.NL).addExt(header, Text.INDEXES);
            if (meta.oldindex()) {
                tb.add(' ' + Text.H_INDEX_FORMAT + Text.NL);
            } else {
                InfoDB.format(tb, Text.UP_TO_DATE, String.valueOf(meta.uptodate));
                InfoDB.format(tb, Text.TEXT_INDEX, Util.flag(meta.textindex));
                InfoDB.format(tb, Text.ATTRIBUTE_INDEX, Util.flag(meta.attrindex));
                InfoDB.format(tb, Text.FULLTEXT_INDEX, Util.flag(meta.ftxtindex));
            }
        }
        return tb.toString();
    }

    @Override
    public void build(CmdBuilder cb) {
        cb.init((Object)((Object)Commands.Cmd.INFO) + " " + (Object)((Object)Commands.CmdInfo.DB));
    }
}

