/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.layout;

import java.awt.Window;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Locale;
import javax.swing.JTextField;
import org.basex.gui.GUI;
import org.basex.gui.GUIConstants;
import org.basex.gui.layout.BaseXDialog;
import org.basex.gui.layout.BaseXEditor;
import org.basex.gui.layout.BaseXKeys;
import org.basex.gui.layout.BaseXLayout;

public class BaseXTextField
extends JTextField {
    public static final int DWIDTH = 350;
    String last = "";
    BaseXEditor area;

    public BaseXTextField(GUI gui) {
        this(null, gui, null);
    }

    public BaseXTextField(BaseXDialog dialog) {
        this(null, dialog, dialog);
    }

    public BaseXTextField(String txt, BaseXDialog dialog) {
        this(txt, dialog, dialog);
    }

    private BaseXTextField(String txt, Window win, final BaseXDialog dialog) {
        BaseXLayout.setWidth(this, 350);
        BaseXLayout.addInteraction(this, win);
        if (txt != null) {
            this.setText(txt);
            this.selectAll();
        }
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (BaseXTextField.this.area != null) {
                    BaseXTextField.this.selectAll();
                    BaseXTextField.this.find(BaseXTextField.this.getText().trim());
                }
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (BaseXKeys.UNDOSTEP.is(e) || BaseXKeys.REDOSTEP.is(e)) {
                    String t = BaseXTextField.this.getText();
                    BaseXTextField.this.setText(BaseXTextField.this.last);
                    BaseXTextField.this.last = t;
                }
                if (BaseXTextField.this.area == null) {
                    return;
                }
                if (BaseXKeys.ESCAPE.is(e) || BaseXKeys.ENTER.is(e) && BaseXTextField.this.getText().trim().isEmpty()) {
                    BaseXTextField.this.area.requestFocusInWindow();
                    BaseXTextField.this.setBackground(GUIConstants.WHITE);
                } else if (BaseXKeys.FINDPREV.is(e) || BaseXKeys.FINDPREV2.is(e) || BaseXKeys.ENTER.is(e) && e.isShiftDown()) {
                    BaseXTextField.this.area.find(false);
                } else if (BaseXKeys.FINDNEXT.is(e) || BaseXKeys.FINDNEXT2.is(e) || BaseXKeys.ENTER.is(e)) {
                    BaseXTextField.this.area.find(true);
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (BaseXTextField.this.area != null) {
                    BaseXTextField.this.find();
                }
            }
        });
        if (dialog != null) {
            this.addKeyListener(dialog.keys);
        }
        this.setDragEnabled(true);
        BaseXLayout.addDrop(this, new BaseXLayout.DropHandler(){

            @Override
            public void drop(Object object) {
                BaseXTextField.this.setText(object.toString());
                BaseXTextField.this.find();
                if (dialog != null) {
                    dialog.action(BaseXTextField.this);
                }
            }
        });
    }

    void find() {
        String old;
        if (this.area == null) {
            return;
        }
        String text = this.getText().trim().toLowerCase(Locale.ENGLISH);
        if (text.equals(old = this.area.keyword(text))) {
            return;
        }
        this.find(text);
    }

    void find(String t) {
        this.setBackground(this.area.find() || t.isEmpty() ? GUIConstants.WHITE : GUIConstants.LRED);
    }

    public final void setSearch(BaseXEditor a) {
        this.area = a;
        BaseXLayout.setWidth(this, 100);
    }

    @Override
    public void setText(String txt) {
        this.last = txt;
        super.setText(txt);
    }
}

