/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLDecoder;
import org.basex.core.BaseXException;
import org.basex.core.Prop;
import org.basex.core.Text;
import org.basex.io.IO;
import org.basex.io.IOFile;
import org.basex.io.in.BufferInput;
import org.basex.util.Token;
import org.basex.util.Util;
import org.xml.sax.InputSource;

public final class IOUrl
extends IO {
    public IOUrl(String u) {
        super(u);
    }

    @Override
    public byte[] read() throws IOException {
        return new BufferInput(this).content();
    }

    @Override
    public InputSource inputSource() {
        return new InputSource(this.path);
    }

    @Override
    public InputStream inputStream() throws IOException {
        URL url = new URL(this.path);
        try {
            return url.openStream();
        }
        catch (IOException ex) {
            IOException io = new IOException(Util.message(ex));
            io.setStackTrace(ex.getStackTrace());
            throw io;
        }
        catch (RuntimeException ex) {
            Util.debug(ex);
            throw new BaseXException(Text.NOT_PARSED_X, this.path);
        }
    }

    @Override
    public String dir() {
        return this.path.endsWith("/") ? this.path : this.path.substring(0, this.path.lastIndexOf(47) + 1);
    }

    @Override
    public IO merge(String f) {
        IO io = IO.get(f);
        if (!(io instanceof IOFile) || f.contains(":") || f.startsWith("/")) {
            return io;
        }
        return IO.get((this.path.endsWith("/") ? this.path : this.path.replace("^(.*/).*", "$1")) + f);
    }

    public static String file(String url) {
        String file = url;
        try {
            if (file.indexOf(37) != -1) {
                file = URLDecoder.decode(file, Prop.ENCODING);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (file.startsWith("file:")) {
            file = file.substring("file:".length());
        }
        if ((file = IOUrl.normSlashes(file)).length() > 2 && file.charAt(0) == '/' && file.charAt(2) == ':' && Token.letter(file.charAt(1))) {
            file = file.substring(1);
        }
        return file;
    }

    private static String normSlashes(String path) {
        boolean a = true;
        StringBuilder sb = new StringBuilder(path.length());
        int pl = path.length();
        for (int p = 0; p < pl; ++p) {
            boolean b;
            char c = path.charAt(p);
            boolean bl = b = c != '/';
            if (a || b) {
                sb.append(c);
            }
            a = b;
        }
        return sb.toString();
    }

    static boolean isValid(String url) {
        char c;
        int u = -1;
        int us = url.length();
        while (++u < us && (Token.letterOrDigit(c = url.charAt(u)) || c == '+' || c == '-' || c == '.')) {
        }
        return u > 2 && u + 1 < us && url.charAt(u) == ':' && url.charAt(u + 1) == '/';
    }

    static boolean isFileURL(String s) {
        return s.startsWith("file:/");
    }
}

