/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Context;
import org.basex.query.expr.Expr;
import org.basex.query.expr.ParseExpr;
import org.basex.query.func.UserFuncCall;
import org.basex.query.iter.Iter;
import org.basex.query.util.Var;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.FElem;
import org.basex.util.InputInfo;
import org.basex.util.TokenBuilder;
import org.basex.util.list.StringList;

public final class VarRef
extends ParseExpr {
    public Var var;

    public VarRef(InputInfo ii, Var v) {
        super(ii);
        this.var = v;
    }

    @Override
    public void checkUp() throws QueryException {
    }

    @Override
    public Expr compile(QueryContext ctx) throws QueryException {
        this.var = ctx.vars.get(this.var);
        this.type = this.var.type();
        this.size = this.var.size();
        Expr e = this.var.expr();
        if (e == null) {
            return this;
        }
        if (this.var.global || this.var.type != null || e.uses(Expr.Use.CNS) || e instanceof UserFuncCall) {
            e = this.var.value(ctx);
        }
        return e;
    }

    @Override
    public Item item(QueryContext ctx, InputInfo ii) throws QueryException {
        this.var = ctx.vars.get(this.var);
        return this.var.item(ctx, ii);
    }

    @Override
    public Iter iter(QueryContext ctx) throws QueryException {
        this.var = ctx.vars.get(this.var);
        return ctx.iter(this.var);
    }

    @Override
    public Value value(QueryContext ctx) throws QueryException {
        this.var = ctx.vars.get(this.var);
        return ctx.value(this.var);
    }

    @Override
    public boolean uses(Expr.Use u) {
        return u == Expr.Use.VAR || u != Expr.Use.CTX && u != Expr.Use.NDT && this.var.expr() != null && this.var.expr().uses(u);
    }

    @Override
    public int count(Var v) {
        return this.var.is(v) ? 1 : 0;
    }

    @Override
    public boolean removable(Var v) {
        return true;
    }

    @Override
    public Expr remove(Var v) {
        return this.var.is(v) ? new Context(this.info) : this;
    }

    @Override
    public boolean databases(StringList db) {
        return true;
    }

    @Override
    public boolean sameAs(Expr cmp) {
        return cmp instanceof VarRef && this.var.sameAs(((VarRef)cmp).var);
    }

    @Override
    public void plan(FElem plan) {
        this.addPlan(plan, this.planElem(new Object[0]), this.var);
    }

    @Override
    public String description() {
        return "Variable";
    }

    @Override
    public String toString() {
        return new TokenBuilder("$").add(this.var.name.string()).toString();
    }
}

