/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.ft;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.ft.FTExpr;
import org.basex.query.iter.FTIter;
import org.basex.query.util.Err;
import org.basex.query.util.IndexContext;
import org.basex.query.util.Var;
import org.basex.query.value.node.FElem;
import org.basex.query.value.node.FTNode;
import org.basex.util.InputInfo;
import org.basex.util.list.StringList;

public final class FTWeight
extends FTExpr {
    private Expr weight;

    public FTWeight(InputInfo ii, FTExpr e, Expr w) {
        super(ii, e);
        this.weight = w;
    }

    @Override
    public void checkUp() throws QueryException {
        this.checkNoUp(this.weight);
        super.checkUp();
    }

    @Override
    public FTExpr compile(QueryContext ctx) throws QueryException {
        this.weight = this.weight.compile(ctx);
        return super.compile(ctx);
    }

    @Override
    public FTNode item(QueryContext ctx, InputInfo ii) throws QueryException {
        return this.weight(this.expr[0].item(ctx, this.info), ctx);
    }

    @Override
    public FTIter iter(final QueryContext ctx) {
        return new FTIter(){

            @Override
            public FTNode next() throws QueryException {
                return FTWeight.this.weight(FTWeight.this.expr[0].iter(ctx).next(), ctx);
            }
        };
    }

    FTNode weight(FTNode item, QueryContext ctx) throws QueryException {
        if (item == null) {
            return null;
        }
        double d = this.checkDbl(this.weight, ctx);
        if (Math.abs(d) > 1000.0) {
            Err.FTWEIGHT.thrw(this.info, d);
        }
        if (d == 0.0) {
            item.all.size = 0;
        }
        item.score(item.score() * d);
        return item;
    }

    @Override
    public boolean indexAccessible(IndexContext ic) {
        return false;
    }

    @Override
    public boolean uses(Expr.Use u) {
        return this.weight.uses(u) || super.uses(u);
    }

    @Override
    public int count(Var v) {
        return this.weight.count(v) + super.count(v);
    }

    @Override
    public boolean removable(Var v) {
        return this.weight.removable(v) && super.removable(v);
    }

    @Override
    public FTExpr remove(Var v) {
        this.weight = this.weight.remove(v);
        return super.remove(v);
    }

    @Override
    public boolean databases(StringList db) {
        return this.weight.databases(db) && super.databases(db);
    }

    @Override
    public void plan(FElem plan) {
        this.addPlan(plan, this.planElem(new Object[0]), this.weight, this.expr[0]);
    }

    @Override
    public String toString() {
        return this.expr[0] + " " + "weight" + ' ' + this.weight;
    }
}

