/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.regex.Pattern;
import org.basex.core.Prop;
import org.basex.io.IOFile;
import org.basex.io.IOUrl;
import org.basex.io.in.BufferInput;
import org.basex.io.out.BufferOutput;
import org.basex.io.out.PrintOutput;
import org.basex.io.serial.Serializer;
import org.basex.io.serial.SerializerException;
import org.basex.io.serial.SerializerProp;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.func.FNGen;
import org.basex.query.func.FuncParams;
import org.basex.query.func.Function;
import org.basex.query.func.StandardFunc;
import org.basex.query.iter.Iter;
import org.basex.query.util.Err;
import org.basex.query.value.item.B64Stream;
import org.basex.query.value.item.Bin;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Dtm;
import org.basex.query.value.item.Int;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Str;
import org.basex.query.value.item.StrStream;
import org.basex.query.value.item.Uri;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.Type;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.list.StringList;

public final class FNFile
extends StandardFunc {
    private static final byte[] NL = Token.token(Prop.NL);

    public FNFile(InputInfo ii, Function f, Expr ... e) {
        super(ii, f, e);
    }

    @Override
    public Iter iter(QueryContext ctx) throws QueryException {
        this.checkCreate(ctx);
        File path = this.file(0, ctx);
        switch (this.sig) {
            case _FILE_LIST: {
                return this.list(path, ctx);
            }
            case _FILE_READ_TEXT_LINES: {
                return this.readTextLines(path, ctx);
            }
        }
        return super.iter(ctx);
    }

    @Override
    public Item item(QueryContext ctx, InputInfo ii) throws QueryException {
        this.checkCreate(ctx);
        File path = this.file(0, ctx);
        try {
            switch (this.sig) {
                case _FILE_APPEND: {
                    return this.write(path, true, ctx);
                }
                case _FILE_APPEND_BINARY: {
                    return this.writeBinary(path, ctx, true);
                }
                case _FILE_APPEND_TEXT: {
                    return this.writeText(path, true, ctx);
                }
                case _FILE_APPEND_TEXT_LINES: {
                    return this.writeTextLines(path, true, ctx);
                }
                case _FILE_COPY: {
                    return this.copy(path, ctx, true);
                }
                case _FILE_CREATE_DIR: {
                    return this.createDirectory(path);
                }
                case _FILE_DELETE: {
                    return this.delete(path, ctx);
                }
                case _FILE_MOVE: {
                    return this.copy(path, ctx, false);
                }
                case _FILE_READ_BINARY: {
                    return this.readBinary(path);
                }
                case _FILE_READ_TEXT: {
                    return this.readText(path, ctx);
                }
                case _FILE_WRITE: {
                    return this.write(path, false, ctx);
                }
                case _FILE_WRITE_BINARY: {
                    return this.writeBinary(path, ctx, false);
                }
                case _FILE_WRITE_TEXT: {
                    return this.writeText(path, false, ctx);
                }
                case _FILE_WRITE_TEXT_LINES: {
                    return this.writeTextLines(path, false, ctx);
                }
                case _FILE_PATH_SEPARATOR: {
                    return Str.get(File.pathSeparator);
                }
                case _FILE_DIR_SEPARATOR: {
                    return Str.get(File.separator);
                }
                case _FILE_LINE_SEPARATOR: {
                    return Str.get(NL);
                }
                case _FILE_EXISTS: {
                    return Bln.get(path.exists());
                }
                case _FILE_IS_DIR: {
                    return Bln.get(path.isDirectory());
                }
                case _FILE_IS_FILE: {
                    return Bln.get(path.isFile());
                }
                case _FILE_LAST_MODIFIED: {
                    return this.lastModified(path);
                }
                case _FILE_SIZE: {
                    return this.size(path);
                }
                case _FILE_BASE_NAME: {
                    return this.baseName(path, ctx);
                }
                case _FILE_DIR_NAME: {
                    return FNFile.dirName(path);
                }
                case _FILE_PATH_TO_NATIVE: {
                    return this.pathToNative(path);
                }
                case _FILE_RESOLVE_PATH: {
                    return Str.get(path.getAbsolutePath());
                }
                case _FILE_PATH_TO_URI: {
                    return FNFile.pathToUri(path);
                }
            }
            return super.item(ctx, ii);
        }
        catch (IOException ex) {
            throw Err.FILE_IO.thrw(this.info, ex);
        }
    }

    private Item lastModified(File path) throws QueryException {
        if (!path.exists()) {
            Err.FILE_WHICH.thrw(this.info, path.getAbsolutePath());
        }
        return new Dtm(path.lastModified(), this.info);
    }

    private Item size(File path) throws QueryException {
        if (!path.exists()) {
            Err.FILE_WHICH.thrw(this.info, path.getAbsolutePath());
        }
        if (path.isDirectory()) {
            Err.FILE_DIR.thrw(this.info, path.getAbsolutePath());
        }
        return Int.get(path.length());
    }

    private Str baseName(File path, QueryContext ctx) throws QueryException {
        if (path.getPath().isEmpty()) {
            return Str.get(".");
        }
        String suf = this.expr.length < 2 ? null : Token.string(this.checkStr(this.expr[1], ctx));
        String pth = path.getName();
        if (suf != null && pth.endsWith(suf)) {
            pth = pth.substring(0, pth.length() - suf.length());
        }
        return Str.get(pth);
    }

    private static Str dirName(File path) {
        String pth = path.getParent();
        return Str.get(pth == null ? "." : pth);
    }

    private Str pathToNative(File path) throws QueryException {
        try {
            return Str.get(path.getCanonicalFile());
        }
        catch (IOException ex) {
            throw Err.FILE_PATH.thrw(this.info, path);
        }
    }

    private static Uri pathToUri(File path) {
        return Uri.uri(Token.token(path.toURI().toString()));
    }

    private Iter list(File path, QueryContext ctx) throws QueryException {
        File dir;
        try {
            dir = new File(path.getCanonicalPath().replaceAll("[\\\\/]$", ""));
        }
        catch (IOException ex) {
            throw Err.FILE_PATH.thrw(this.info, path);
        }
        if (!dir.isDirectory()) {
            Err.FILE_NODIR.thrw(this.info, dir);
        }
        boolean rec = this.optionalBool(1, ctx);
        Pattern pat = this.expr.length != 3 ? null : Pattern.compile(IOFile.regex(Token.string(this.checkStr(this.expr[2], ctx))), Prop.WIN ? 2 : 0);
        final StringList list = new StringList();
        this.list(dir.getPath().length() + 1, dir, list, rec, pat);
        return new Iter(){
            int c;

            @Override
            public Item next() {
                return this.c < list.size() ? Str.get(list.get(this.c++)) : null;
            }
        };
    }

    private void list(int root, File dir, StringList list, boolean rec, Pattern pat) throws QueryException {
        File[] ch = dir.listFiles();
        if (ch == null) {
            return;
        }
        if (rec) {
            for (File f : ch) {
                if (this.mayBeLink(f) || !f.isDirectory()) continue;
                this.list(root, f, list, rec, pat);
            }
        }
        for (File f : ch) {
            if (pat != null && (!pat.matcher(f.getName()).matches() || f.isDirectory())) continue;
            list.add(f.getPath().substring(root));
        }
    }

    private boolean mayBeLink(File f) throws QueryException {
        try {
            String p1 = f.getAbsolutePath();
            String p2 = f.getCanonicalPath();
            return !(!Prop.WIN ? p1.equals(p2) : p1.equalsIgnoreCase(p2));
        }
        catch (IOException ex) {
            throw Err.FILE_PATH.thrw(this.info, f);
        }
    }

    private synchronized Item createDirectory(File path) throws QueryException {
        File f;
        try {
            f = path.getCanonicalFile();
        }
        catch (IOException ex) {
            throw Err.FILE_PATH.thrw(this.info, path);
        }
        while (!f.exists()) {
            if ((f = f.getParentFile()) != null) continue;
            throw Err.FILE_PATH.thrw(this.info, path);
        }
        if (f.isFile()) {
            Err.FILE_EXISTS.thrw(this.info, path);
        }
        if (!path.exists() && !path.mkdirs()) {
            Err.FILE_CREATE.thrw(this.info, path);
        }
        return null;
    }

    private synchronized Item delete(File path, QueryContext ctx) throws QueryException {
        if (!path.exists()) {
            Err.FILE_WHICH.thrw(this.info, path.getAbsolutePath());
        }
        if (this.optionalBool(1, ctx)) {
            this.deleteRec(path);
        } else if (!path.delete()) {
            throw (path.isDirectory() ? Err.FILE_NEDIR : Err.FILE_DEL).thrw(this.info, path);
        }
        return null;
    }

    private synchronized void deleteRec(File path) throws QueryException {
        File[] ch = path.listFiles();
        if (ch != null) {
            for (File f : ch) {
                this.deleteRec(f);
            }
        }
        if (!path.delete()) {
            Err.FILE_DEL.thrw(this.info, path);
        }
    }

    private B64Stream readBinary(File path) throws QueryException {
        if (!path.exists()) {
            Err.FILE_WHICH.thrw(this.info, path.getAbsolutePath());
        }
        if (path.isDirectory()) {
            Err.FILE_DIR.thrw(this.info, path.getAbsolutePath());
        }
        return new B64Stream(new IOFile(path), Err.FILE_IO);
    }

    private StrStream readText(File path, QueryContext ctx) throws QueryException {
        String enc = this.encoding(1, Err.FILE_ENCODING, ctx);
        if (!path.exists()) {
            Err.FILE_WHICH.thrw(this.info, path.getAbsolutePath());
        }
        if (path.isDirectory()) {
            Err.FILE_DIR.thrw(this.info, path.getAbsolutePath());
        }
        return new StrStream(new IOFile(path), enc, Err.FILE_IO);
    }

    private Iter readTextLines(File path, QueryContext ctx) throws QueryException {
        return FNGen.textIter(this.readText(path, ctx).string(this.info));
    }

    private synchronized Item write(File path, boolean append, QueryContext ctx) throws QueryException, IOException {
        this.check(path);
        Iter ir = this.expr[1].iter(ctx);
        SerializerProp sp = FuncParams.serializerProp(this.expr.length > 2 ? this.expr[2].item(ctx, this.info) : null);
        PrintOutput out = PrintOutput.get(new FileOutputStream(path, append));
        try {
            Item it;
            Serializer ser = Serializer.get(out, sp);
            while ((it = ir.next()) != null) {
                ser.serialize(it);
            }
            ser.close();
        }
        catch (SerializerException ex) {
            throw ex.getCause(this.info);
        }
        finally {
            out.close();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Item writeText(File path, boolean append, QueryContext ctx) throws QueryException, IOException {
        this.check(path);
        byte[] s = this.checkStr(this.expr[1], ctx);
        String enc = this.encoding(2, Err.FILE_ENCODING, ctx);
        Charset cs = enc == null || enc == "UTF-8" ? null : Charset.forName(enc);
        PrintOutput out = PrintOutput.get(new FileOutputStream(path, append));
        try {
            out.write(cs == null ? s : Token.string(s).getBytes(cs));
        }
        finally {
            out.close();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Item writeTextLines(File path, boolean append, QueryContext ctx) throws QueryException, IOException {
        this.check(path);
        Iter ir = this.expr[1].iter(ctx);
        String enc = this.encoding(2, Err.FILE_ENCODING, ctx);
        Charset cs = enc == null || enc == "UTF-8" ? null : Charset.forName(enc);
        PrintOutput out = PrintOutput.get(new FileOutputStream(path, append));
        try {
            Item it;
            while ((it = ir.next()) != null) {
                Type ip = it.type;
                if (!ip.isString() && !ip.isUntyped()) {
                    Err.type(this, AtomType.STR, it);
                }
                byte[] s = it.string(this.info);
                out.write(cs == null ? s : Token.string(s).getBytes(cs));
                out.write(cs == null ? NL : Prop.NL.getBytes(cs));
            }
        }
        finally {
            out.close();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Item writeBinary(File path, QueryContext ctx, boolean append) throws QueryException, IOException {
        this.check(path);
        Iter ir = this.expr[1].iter(ctx);
        BufferOutput out = new BufferOutput(new FileOutputStream(path, append));
        try {
            Item it;
            while ((it = ir.next()) != null) {
                if (!(it instanceof Bin)) {
                    Err.BINARYTYPE.thrw(this.info, it.type);
                }
                BufferInput is = it.input(this.info);
                try {
                    int i;
                    while ((i = ((InputStream)is).read()) != -1) {
                        out.write(i);
                    }
                }
                finally {
                    ((InputStream)is).close();
                }
            }
        }
        finally {
            out.close();
        }
        return null;
    }

    private void check(File path) throws QueryException {
        IOFile dir;
        IOFile io = new IOFile(path);
        if (io.isDir()) {
            Err.FILE_DIR.thrw(this.info, io);
        }
        if (!(dir = new IOFile(io.dir())).exists()) {
            Err.FILE_NODIR.thrw(this.info, dir);
        }
    }

    private synchronized Item copy(File src, QueryContext ctx, boolean copy) throws QueryException, IOException {
        File trg = this.file(1, ctx).getAbsoluteFile();
        if (!src.exists()) {
            Err.FILE_WHICH.thrw(this.info, src.getAbsolutePath());
        }
        if (trg.isDirectory()) {
            if ((trg = new File(trg, src.getName())).isDirectory()) {
                Err.FILE_DIR.thrw(this.info, trg);
            }
        } else if (!trg.isFile()) {
            if (!trg.getParentFile().isDirectory()) {
                Err.FILE_NODIR.thrw(this.info, trg);
            }
        } else if (src.isDirectory()) {
            Err.FILE_DIR.thrw(this.info, src);
        }
        if (!src.equals(trg)) {
            if (copy) {
                this.copy(src, trg);
            } else if (!src.renameTo(trg)) {
                Err.FILE_MOVE.thrw(this.info, src, trg);
            }
        }
        return null;
    }

    private synchronized void copy(File src, File trg) throws QueryException, IOException {
        if (src.isDirectory()) {
            File[] files;
            if (!trg.mkdir()) {
                Err.FILE_CREATE.thrw(this.info, trg);
            }
            if ((files = src.listFiles()) == null) {
                Err.FILE_LIST.thrw(this.info, src);
            }
            for (File f : files) {
                this.copy(f, new File(trg, f.getName()));
            }
        } else {
            new IOFile(src).copyTo(new IOFile(trg));
        }
    }

    private boolean optionalBool(int i, QueryContext ctx) throws QueryException {
        return i < this.expr.length && this.checkBln(this.expr[i], ctx);
    }

    private File file(int i, QueryContext ctx) throws QueryException {
        return i >= this.expr.length ? null : new IOFile(IOUrl.file(Token.string(this.checkStr(this.expr[i], ctx)))).file();
    }

    @Override
    public boolean uses(Expr.Use u) {
        return u == Expr.Use.NDT && !FNFile.oneOf(this.sig, Function._FILE_BASE_NAME, Function._FILE_DIR_NAME, Function._FILE_DIR_SEPARATOR, Function._FILE_PATH_SEPARATOR, Function._FILE_PATH_TO_NATIVE, Function._FILE_PATH_TO_URI, Function._FILE_RESOLVE_PATH) || super.uses(u);
    }
}

