/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.path;

import org.basex.data.Data;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.iter.Iter;
import org.basex.query.iter.NodeSeqBuilder;
import org.basex.query.iter.ValueBuilder;
import org.basex.query.iter.ValueIter;
import org.basex.query.path.AxisStep;
import org.basex.query.path.Bang;
import org.basex.query.path.Path;
import org.basex.query.util.Err;
import org.basex.query.util.Var;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.ANode;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.SeqType;
import org.basex.util.InputInfo;

public final class MixedPath
extends Path {
    public MixedPath(InputInfo ii, Expr r, Expr ... s) {
        super(ii, r, s);
    }

    @Override
    protected Expr compilePath(QueryContext ctx) throws QueryException {
        Expr e;
        AxisStep v = this.voidStep(this.steps);
        if (v != null) {
            Err.COMPSELF.thrw(this.info, v);
        }
        for (int s = 0; s != this.steps.length; ++s) {
            this.steps[s] = this.steps[s].compile(ctx);
            if (!this.steps[s].isEmpty()) continue;
            return Empty.SEQ;
        }
        this.optSteps(ctx);
        Data data = ctx.data();
        if (data != null && ctx.value.type == NodeType.DOC && (e = this.children(ctx, data)) != this) {
            return e.compile(ctx);
        }
        this.size = this.size(ctx);
        this.type = SeqType.get(this.steps[this.steps.length - 1].type().type, this.size);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iter iter(QueryContext ctx) throws QueryException {
        Value v = this.root != null ? ctx.value(this.root) : this.checkCtx(ctx);
        ValueIter res = v.iter();
        Value cv = ctx.value;
        long cs = ctx.size;
        long cp = ctx.pos;
        try {
            int el = this.steps.length;
            for (int ex = 0; ex < el; ++ex) {
                Item it;
                Expr e = this.steps[ex];
                boolean path = !(e instanceof Bang);
                boolean last = ex + 1 == el;
                ValueBuilder vb = new ValueBuilder();
                boolean nodes = false;
                ctx.size = ((Iter)res).size();
                ctx.pos = 1L;
                while ((it = ((Iter)res).next()) != null) {
                    Item i;
                    if (path && !it.type.isNode()) {
                        Err.NODESPATH.thrw(this.info, this, it.type);
                    }
                    ctx.value = it;
                    Iter ir = ctx.iter(e);
                    while ((i = ir.next()) != null) {
                        if (path) {
                            if (vb.size() == 0L) {
                                nodes = i.type.isNode();
                            } else if (last && nodes != i.type.isNode()) {
                                Err.EVALNODESVALS.thrw(this.info, new Object[0]);
                            }
                        }
                        vb.add(i);
                    }
                    ++ctx.pos;
                }
                if (nodes && path) {
                    Item it2;
                    NodeSeqBuilder nc = new NodeSeqBuilder().check();
                    while ((it2 = vb.next()) != null) {
                        nc.add((ANode)it2);
                    }
                    res = nc.value().cache();
                    continue;
                }
                res = vb;
            }
            ValueIter valueIter = res;
            return valueIter;
        }
        finally {
            ctx.value = cv;
            ctx.size = cs;
            ctx.pos = cp;
        }
    }

    @Override
    public int count(Var v) {
        int c = 0;
        for (Expr e : this.steps) {
            c += e.count(v);
        }
        return c + super.count(v);
    }

    @Override
    public boolean removable(Var v) {
        for (Expr e : this.steps) {
            if (!e.uses(Expr.Use.VAR)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Expr remove(Var v) {
        for (int e = 0; e != this.steps.length; ++e) {
            this.steps[e] = this.steps[e].remove(v);
        }
        return super.remove(v);
    }
}

