/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util.format;

import java.util.HashMap;
import java.util.Map;
import org.basex.query.QueryException;
import org.basex.query.expr.Calc;
import org.basex.query.func.FNNum;
import org.basex.query.util.Err;
import org.basex.query.util.format.FormatUtil;
import org.basex.query.value.item.Int;
import org.basex.query.value.item.Item;
import org.basex.util.Array;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.hash.IntSet;
import org.basex.util.list.TokenList;

public final class DecFormatter
extends FormatUtil {
    private final String digits;
    private final String active;
    private String inf = "Infinity";
    private String nan = "NaN";
    private int pattern = 59;
    private int decimal = 46;
    private int grouping = 44;
    private int optional = 35;
    private int minus = 45;
    private int percent = 37;
    private int permille = 8240;

    public DecFormatter() throws QueryException {
        this(null, null);
    }

    public DecFormatter(InputInfo ii, HashMap<String, String> map) throws QueryException {
        int zero = 48;
        if (map != null) {
            for (Map.Entry<String, String> e : map.entrySet()) {
                int cp;
                String key = e.getKey();
                String val = e.getValue();
                int n = cp = val.isEmpty() ? 0 : val.codePointAt(0);
                if (Character.charCount(cp) != val.length()) {
                    cp = 0;
                }
                if (key.equals("infinity")) {
                    this.inf = val;
                    continue;
                }
                if (key.equals("NaN")) {
                    this.nan = val;
                    continue;
                }
                if (cp != 0) {
                    if (key.equals("decimal-separator")) {
                        this.decimal = cp;
                        continue;
                    }
                    if (key.equals("grouping-separator")) {
                        this.grouping = cp;
                        continue;
                    }
                    if (key.equals("pattern-separator")) {
                        this.pattern = cp;
                        continue;
                    }
                    if (key.equals("minus-sign")) {
                        this.minus = cp;
                        continue;
                    }
                    if (key.equals("digit")) {
                        this.optional = cp;
                        continue;
                    }
                    if (key.equals("percent")) {
                        this.percent = cp;
                        continue;
                    }
                    if (key.equals("per-mille")) {
                        this.permille = cp;
                        continue;
                    }
                    if (!key.equals("zero-digit") || (zero = DecFormatter.zeroes(cp)) != -1) continue;
                    Err.INVDECFORM.thrw(ii, key, val);
                    continue;
                }
                Err.INVDECFORM.thrw(ii, key, val);
            }
        }
        IntSet is = new IntSet();
        for (int i : new int[]{this.decimal, this.grouping, this.percent, this.permille, zero, this.optional, this.pattern}) {
            if (is.add(i) >= 0) continue;
            Err.DUPLDECFORM.thrw(ii, Character.valueOf((char)i));
        }
        TokenBuilder tb = new TokenBuilder();
        for (int i = 0; i < 10; ++i) {
            tb.add(zero + i);
        }
        this.digits = tb.toString();
        this.active = tb.add(this.decimal).add(this.grouping).add(this.optional).toString();
    }

    public byte[] format(InputInfo ii, Item number, String picture) throws QueryException {
        TokenList tl = new TokenList();
        String pic = picture;
        int i = pic.indexOf(this.pattern);
        if (i == -1) {
            tl.add(pic);
        } else {
            tl.add(pic.substring(0, i));
            pic = pic.substring(i + 1);
            if (pic.indexOf(this.pattern) != -1) {
                Err.PICNUM.thrw(ii, picture);
            }
            tl.add(pic);
        }
        byte[][] patterns = tl.toArray();
        if (!this.check(patterns)) {
            Err.PICNUM.thrw(ii, picture);
        }
        Picture[] pics = this.analyze(patterns);
        return Token.token(this.format(number, pics, ii));
    }

    private boolean check(byte[][] patterns) {
        for (byte[] pt : patterns) {
            int cl;
            boolean frac = false;
            boolean pas = false;
            boolean act = false;
            boolean dg = false;
            boolean opt1 = false;
            boolean opt2 = false;
            int pc = 0;
            int pm = 0;
            int ls = 0;
            for (int i = 0; i < pt.length; i += cl) {
                boolean a;
                int ch = DecFormatter.ch(pt, i);
                cl = Token.cl(pt, i);
                boolean bl = a = this.active.indexOf(ch) != -1;
                if (ch == this.decimal) {
                    if (frac) {
                        return false;
                    }
                    frac = true;
                } else if (ch == this.grouping) {
                    if (i == 0 && frac || ls == this.decimal || i + cl < pt.length ? DecFormatter.ch(pt, i + cl) == this.decimal : !frac) {
                        return false;
                    }
                } else if (ch == this.percent) {
                    if (++pc > 1) {
                        return false;
                    }
                } else if (ch == this.permille) {
                    if (++pm > 1) {
                        return false;
                    }
                } else if (ch == this.optional) {
                    if (!frac) {
                        if (dg) {
                            return false;
                        }
                        opt1 = true;
                    } else {
                        opt2 = true;
                    }
                } else if (this.digits.indexOf(ch) != -1) {
                    if (frac && opt2) {
                        return false;
                    }
                    dg = true;
                }
                if (a && pas && act) {
                    return false;
                }
                if (act) {
                    pas |= !a;
                }
                act |= a;
                ls = ch;
            }
            if (pc + pm > 1) {
                return false;
            }
            if (opt1 || opt2 || dg) continue;
            return false;
        }
        return true;
    }

    private Picture[] analyze(byte[][] patterns) {
        Picture[] pics = new Picture[patterns.length];
        for (int s = 0; s < patterns.length; ++s) {
            byte[] pt = patterns[s];
            Picture pic = new Picture();
            int p = 0;
            boolean act = false;
            int[] opt = new int[2];
            for (int i = 0; i < pt.length; i += Token.cl(pt, i)) {
                boolean a;
                int ch = DecFormatter.ch(pt, i);
                boolean bl = a = this.active.indexOf(ch) != -1;
                if (ch == this.decimal) {
                    ++p;
                    act = false;
                } else if (ch == this.optional) {
                    int n = p;
                    opt[n] = opt[n] + 1;
                } else if (ch == this.grouping) {
                    if (p == 0) {
                        pic.group[p] = Array.add(pic.group[p], pic.min[p] + opt[p]);
                    }
                } else if (this.digits.indexOf(ch) != -1) {
                    int n = p;
                    pic.min[n] = pic.min[n] + 1;
                } else {
                    pic.pc = pic.pc | ch == this.percent;
                    pic.pm = pic.pm | ch == this.permille;
                    pic.fix[p == 0 && act ? p + 1 : p].add(ch);
                }
                act |= a;
            }
            int[] igp = pic.group[0];
            int igl = igp.length;
            for (int g = 0; g < igl; ++g) {
                igp[g] = pic.min[0] + opt[0] - igp[g];
            }
            if (igl > 1) {
                boolean reg = true;
                int i = igp[igl - 1];
                for (int g = igl - 2; g >= 0; --g) {
                    reg &= i * igl == igp[g];
                }
                if (reg) {
                    pic.group[0] = new int[]{i};
                }
            }
            pic.maxFrac = pic.min[1] + opt[1];
            pics[s] = pic;
        }
        return pics;
    }

    private String format(Item it, Picture[] pics, InputInfo ii) throws QueryException {
        int fl;
        int il;
        int i;
        String str;
        double d = it.dbl(ii);
        if (Double.isNaN(d)) {
            return this.nan;
        }
        Picture pic = pics[d < 0.0 && pics.length == 2 ? 1 : 0];
        if (d == Double.POSITIVE_INFINITY) {
            return pic.fix[0] + this.inf + pic.fix[1];
        }
        if (d == Double.NEGATIVE_INFINITY) {
            return new TokenBuilder(pic.fix[0].finish()).add(this.minus) + this.inf + pic.fix[1];
        }
        Item num = it;
        if (pic.pc) {
            num = Calc.MULT.ev(ii, num, Int.get(100L));
        }
        if (pic.pm) {
            num = Calc.MULT.ev(ii, num, Int.get(1000L));
        }
        if ((str = (num = FNNum.round(num, num.dbl(ii), pic.maxFrac, true, ii)).toString()).startsWith("0.")) {
            str = str.substring(1);
        }
        int sp = str.indexOf(this.decimal);
        TokenBuilder pre = new TokenBuilder();
        for (i = il = sp == -1 ? str.length() : sp; i < pic.min[0]; ++i) {
            pre.add(48);
        }
        pre.add(str.substring(0, il));
        if (pic.group[0].length == 1) {
            int pos = pic.group[0][0];
            for (int p = pre.size() - 1; p > 0; --p) {
                if (p % pos != 0) continue;
                pre.insert(pre.size() - p, this.grouping);
            }
        } else {
            for (i = 0; i < pic.group[0].length; ++i) {
                int pos = pre.size() - pic.group[0][i];
                if (pos <= 0) continue;
                pre.insert(pos, this.grouping);
            }
        }
        TokenBuilder suf = new TokenBuilder();
        int n = fl = sp == -1 ? 0 : str.length() - il - 1;
        if (fl != 0) {
            suf.add(str.substring(sp + 1));
        }
        for (int i2 = fl; i2 < pic.min[1]; ++i2) {
            suf.add(48);
        }
        int sl = suf.size();
        for (int i3 = pic.group[1].length - 1; i3 >= 0; --i3) {
            int pos = pic.group[1][i3];
            if (pos >= sl) continue;
            suf.insert(pos, this.grouping);
        }
        TokenBuilder res = new TokenBuilder(pic.fix[0].finish());
        res.add(pre.finish());
        if (!suf.isEmpty()) {
            res.add(this.decimal).add(suf.finish());
        }
        return res.add(pic.fix[1].finish()).toString();
    }

    static final class Picture {
        final TokenBuilder[] fix = new TokenBuilder[]{new TokenBuilder(), new TokenBuilder()};
        final int[][] group = new int[][]{new int[0], new int[0]};
        final int[] min = new int[]{0, 0};
        int maxFrac;
        boolean pc;
        boolean pm;

        Picture() {
        }
    }
}

