/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.export;

import java.util.ArrayList;
import java.util.Arrays;
import nl.mpi.kinnate.kindata.DataTypes;
import nl.mpi.kinnate.kindata.EntityData;
import nl.mpi.kinnate.kindata.EntityRelation;
import nl.mpi.kinnate.kintypestrings.KinTypeStringConverter;
import nl.mpi.kinnate.kintypestrings.ParserHighlight;
import nl.mpi.kinnate.svg.DataStoreSvg;
import nl.mpi.kinnate.ui.KinTypeStringProvider;
import nl.mpi.kinnate.uniqueidentifiers.UniqueIdentifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PedigreePackageExport {
    private final String defaultSymbol;
    private static UniqueIdentifier orphanId = new UniqueIdentifier("orphan", UniqueIdentifier.IdentifierType.tid);

    public PedigreePackageExport(String defaultSymbol) {
        this.defaultSymbol = defaultSymbol;
    }

    private String getSimpleId(ArrayList<UniqueIdentifier> allIdArray, UniqueIdentifier entityIdentifier) {
        if (!allIdArray.contains(entityIdentifier)) {
            allIdArray.add(entityIdentifier);
        }
        return Integer.toString(allIdArray.indexOf(entityIdentifier));
    }

    private UniqueIdentifier getFirstMatchingParent(EntityData entityData, EntityData.SymbolType symbolType) {
        for (EntityRelation entityRelation : entityData.getAllRelations()) {
            EntityData alterNode;
            if (!entityRelation.getRelationType().equals((Object)DataTypes.RelationType.ancestor) || (alterNode = entityRelation.getAlterNode()) == null) continue;
            for (String symbolName : alterNode.getSymbolNames(this.defaultSymbol)) {
                if (!symbolName.equals(symbolType.name())) continue;
                return entityRelation.getAlterNode().getUniqueIdentifier();
            }
        }
        return orphanId;
    }

    private int getIntegerGender(EntityData entityData) {
        for (String symbolName : entityData.getSymbolNames(this.defaultSymbol)) {
            if (symbolName.equals(EntityData.SymbolType.triangle.name())) {
                return 1;
            }
            if (!symbolName.equals(EntityData.SymbolType.circle.name())) continue;
            return 2;
        }
        return 3;
    }

    public String createCsvContents(EntityData[] entityDataArray) {
        ArrayList<UniqueIdentifier> allIdArray = new ArrayList<UniqueIdentifier>();
        allIdArray.add(orphanId);
        StringBuilder stringBuilder = new StringBuilder();
        int labelMaxCount = 0;
        ArrayList<String> symbolHeaders = new ArrayList<String>();
        for (EntityData entityData : entityDataArray) {
            for (String symbolName : entityData.getSymbolNames(this.defaultSymbol)) {
                if (symbolHeaders.contains(symbolName)) continue;
                symbolHeaders.add(symbolName);
            }
            int labelCount = entityData.getLabel().length;
            if (labelMaxCount >= labelCount) continue;
            labelMaxCount = labelCount;
        }
        stringBuilder.append("id\tmomid\tdadid\tsex\tego\tdob\tdod");
        for (int labelCounter = 0; labelCounter < labelMaxCount; ++labelCounter) {
            stringBuilder.append("\tlabel_");
            stringBuilder.append(labelCounter);
        }
        for (String symbolString : symbolHeaders) {
            stringBuilder.append("\tsymbol_");
            stringBuilder.append(symbolString);
        }
        stringBuilder.append("\tUniqueIdentifier");
        stringBuilder.append("\n");
        for (EntityData entityData : entityDataArray) {
            this.getSimpleId(allIdArray, entityData.getUniqueIdentifier());
        }
        for (EntityData entityData : entityDataArray) {
            stringBuilder.append(this.getSimpleId(allIdArray, entityData.getUniqueIdentifier()));
            stringBuilder.append("\t");
            stringBuilder.append(this.getSimpleId(allIdArray, this.getFirstMatchingParent(entityData, EntityData.SymbolType.circle)));
            stringBuilder.append("\t");
            stringBuilder.append(this.getSimpleId(allIdArray, this.getFirstMatchingParent(entityData, EntityData.SymbolType.triangle)));
            stringBuilder.append("\t");
            stringBuilder.append(this.getIntegerGender(entityData));
            stringBuilder.append("\t");
            if (entityData.isEgo) {
                stringBuilder.append("1");
            } else {
                stringBuilder.append("0");
            }
            stringBuilder.append("\t");
            if (entityData.getDateOfBirth() != null) {
                stringBuilder.append(entityData.getDateOfBirth().getDateString());
            }
            stringBuilder.append("\t");
            if (entityData.getDateOfDeath() != null) {
                stringBuilder.append(entityData.getDateOfDeath().getDateString());
            }
            stringBuilder.append("\t");
            String[] currentLabels = entityData.getLabel();
            for (int labelCounter = 0; labelCounter < labelMaxCount; ++labelCounter) {
                if (labelCounter < currentLabels.length) {
                    stringBuilder.append(currentLabels[labelCounter]);
                }
                stringBuilder.append("\t");
            }
            ArrayList<String> currentSymbols = new ArrayList<String>(Arrays.asList(entityData.getSymbolNames(this.defaultSymbol)));
            for (String symbolString : symbolHeaders) {
                if (currentSymbols.contains(symbolString)) {
                    stringBuilder.append("1");
                } else {
                    stringBuilder.append("0");
                }
                stringBuilder.append("\t");
            }
            stringBuilder.append(entityData.getUniqueIdentifier().getAttributeIdentifier());
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    public static void main(String[] argsArray) {
        KinTypeStringConverter graphData = new KinTypeStringConverter(new DataStoreSvg());
        KinTypeStringProvider kinTypeStringProvider = new KinTypeStringProvider(){

            public String[] getCurrentStrings() {
                return "EmB,EmZ,EmM,EmF,EmS,EmD".split(",");
            }

            public int getTotalLength() {
                return this.getCurrentStrings().length;
            }

            public void highlightKinTypeStrings(ParserHighlight[] parserHighlight, String[] kinTypeStrings) {
            }
        };
        ArrayList<KinTypeStringProvider> kinTypeStringProviders = new ArrayList<KinTypeStringProvider>();
        kinTypeStringProviders.add(kinTypeStringProvider);
        graphData.readKinTypes(kinTypeStringProviders, new DataStoreSvg());
        System.out.println(new PedigreePackageExport("").createCsvContents(graphData.getDataNodes()));
    }
}

