/*
 * Decompiled with CFR 0.152.
 */
package org.basex.build.file;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.basex.build.file.HTMLProp;
import org.basex.build.xml.XMLParser;
import org.basex.core.Prop;
import org.basex.io.IO;
import org.basex.io.IOContent;
import org.basex.io.in.ArrayInput;
import org.basex.io.in.TextInput;
import org.basex.util.Reflect;
import org.basex.util.Token;
import org.basex.util.Util;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public final class HTMLParser
extends XMLParser {
    private static final String FEATURES = "http://www.ccil.org/~cowan/tagsoup/features/";
    private static final Class<?> READER = Reflect.find("org.ccil.cowan.tagsoup.Parser");
    private static final Constructor<?> WRITER = Reflect.find(Reflect.find("org.ccil.cowan.tagsoup.XMLWriter"), Writer.class);
    private static final Method METHOD = Reflect.method(Reflect.find("org.ccil.cowan.tagsoup.XMLWriter"), "setOutputProperty", String.class, String.class);

    public static boolean available() {
        return READER != null;
    }

    public HTMLParser(IO source, Prop pr) throws IOException {
        super(HTMLParser.toXML(source, pr.get(Prop.HTMLOPT)), pr);
    }

    private static IO toXML(IO io, String options) throws IOException {
        if (READER == null) {
            return io;
        }
        try {
            byte[] content = io.read();
            TextInput ti = new TextInput(new IOContent(content));
            String enc = ti.encoding();
            content = ti.readBytes();
            byte[] encoding = Token.token("charset=");
            int cs = Token.indexOf(content, encoding);
            if (cs > 0) {
                int ce = cs += encoding.length;
                while (++ce < content.length && content[ce] > 40) {
                }
                enc = Token.string(Token.substring(content, cs, ce));
            }
            InputSource is = new InputSource(new ArrayInput(content));
            is.setEncoding(Token.supported(enc) ? Token.normEncoding(enc) : "UTF-8");
            StringWriter sw = new StringWriter();
            XMLReader reader = (XMLReader)Reflect.get(READER);
            Object writer = Reflect.get(WRITER, sw);
            HTMLProp props = new HTMLProp(options);
            String p = "";
            if (props.is(HTMLProp.HTML)) {
                reader.setFeature("http://xml.org/sax/features/namespaces", false);
                HTMLParser.opt("method", "html");
                HTMLParser.opt("omit-xml-declaration", "yes");
            }
            if (props.is(HTMLProp.NONS)) {
                reader.setFeature("http://xml.org/sax/features/namespaces", false);
            }
            if (props.is(HTMLProp.OMITXML)) {
                HTMLParser.opt("omit-xml-declaration", "yes");
            }
            if ((p = props.get(HTMLProp.METHOD)) != null) {
                HTMLParser.opt("method", p);
            }
            if (props.is(HTMLProp.NOBOGONS)) {
                reader.setFeature("http://www.ccil.org/~cowan/tagsoup/features/ignore-bogons", true);
            }
            if (props.is(HTMLProp.NODEFAULTS)) {
                reader.setFeature("http://www.ccil.org/~cowan/tagsoup/features/default-attributes", false);
            }
            if (props.is(HTMLProp.NOCOLONS)) {
                reader.setFeature("http://www.ccil.org/~cowan/tagsoup/features/translate-colons", true);
            }
            if (props.is(HTMLProp.NORESTART)) {
                reader.setFeature("http://www.ccil.org/~cowan/tagsoup/features/restart-elements", false);
            }
            if (props.is(HTMLProp.IGNORABLE)) {
                reader.setFeature("http://www.ccil.org/~cowan/tagsoup/features/ignorable-whitespace", true);
            }
            if (props.is(HTMLProp.EMPTYBOGONS)) {
                reader.setFeature("http://www.ccil.org/~cowan/tagsoup/features/bogons-empty", true);
            }
            if (props.is(HTMLProp.ANY)) {
                reader.setFeature("http://www.ccil.org/~cowan/tagsoup/features/bogons-empty", false);
            }
            if (props.is(HTMLProp.NOROOTBOGONS)) {
                reader.setFeature("http://www.ccil.org/~cowan/tagsoup/features/root-bogons", false);
            }
            if (props.is(HTMLProp.NOCDATA)) {
                reader.setFeature("http://www.ccil.org/~cowan/tagsoup/features/cdata-elements", false);
            }
            if (props.is(HTMLProp.LEXICAL)) {
                reader.setProperty("http://xml.org/sax/properties/lexical-handler", writer);
            }
            if ((p = props.get(HTMLProp.DOCTYPESYS)) != null) {
                HTMLParser.opt("doctype-system", p);
            }
            if ((p = props.get(HTMLProp.DOCTYPEPUB)) != null) {
                HTMLParser.opt("doctype-public", p);
            }
            if ((p = props.get(HTMLProp.ENCODING)) != null) {
                is.setEncoding(p);
            }
            reader.setContentHandler((ContentHandler)writer);
            reader.parse(is);
            return new IOContent(Token.token(sw.toString()), io.name());
        }
        catch (SAXException ex) {
            Util.errln(ex, new Object[0]);
            return io;
        }
    }

    private static void opt(String p, String v) {
        Reflect.invoke(METHOD, WRITER, p, v);
    }
}

