/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core;

import java.util.regex.Pattern;
import org.basex.core.Context;
import org.basex.core.Prop;
import org.basex.io.IOFile;
import org.basex.util.Token;
import org.basex.util.list.StringList;
import org.basex.util.list.TwoWayTokenMap;

public final class Databases {
    public static final Pattern FILES = Pattern.compile(".{3,5}.basex");
    public static final Pattern ZIPPATTERN = Pattern.compile("-\\d{4}-\\d{2}-\\d{2}-\\d{2}-\\d{2}-\\d{2}.zip$");
    final IOFile dbpath;
    private final TwoWayTokenMap databases = new TwoWayTokenMap();
    private final TwoWayTokenMap backups = new TwoWayTokenMap();

    Databases(Context c) {
        this.dbpath = c.mprop.dbpath();
        for (IOFile f : this.dbpath.children()) {
            String name = f.name();
            if (name.endsWith(".zip")) {
                this.add(ZIPPATTERN.split(name)[0], true);
                continue;
            }
            if (!f.isDir() || name.startsWith(".")) continue;
            this.add(name);
        }
    }

    public void add(String db) {
        this.add(db, false);
    }

    public void add(String db, boolean backup) {
        TwoWayTokenMap map = this.map(backup);
        if (!map.contains(db)) {
            map.add(db);
        }
    }

    public void alter(String oldDB, String newDB) {
        this.databases.delete(newDB);
        this.databases.set(this.databases.getKey(oldDB), newDB);
    }

    public boolean delete(String db) {
        return this.delete(db, false);
    }

    public boolean delete(String db, boolean backup) {
        return this.map(backup).delete(db) != -1;
    }

    public StringList list() {
        return this.list(true, true, null);
    }

    public StringList listDBs() {
        return this.list(true, false, null);
    }

    public StringList listDBs(String name) {
        return this.list(true, false, name);
    }

    private StringList list(boolean db, boolean backup, String name) {
        Pattern pattern = Pattern.compile(null == name ? ".*" : (name.matches(".*[*?,].*") ? IOFile.regex(name) : name), Prop.WIN ? 2 : 0);
        StringList dbs = new StringList();
        if (db) {
            Databases.listAll(this.databases, dbs, pattern);
        }
        if (backup) {
            Databases.listAll(this.backups, dbs, pattern);
        }
        dbs.sort(false, true);
        return db && backup ? dbs.unique() : dbs;
    }

    private static void listAll(TwoWayTokenMap dbs, StringList list, Pattern pattern) {
        for (byte[] database : dbs) {
            String name;
            if (null == database || null != (name = Token.string(database)) && !pattern.matcher(name).matches()) continue;
            list.add(name);
        }
    }

    private TwoWayTokenMap map(boolean backup) {
        return backup ? this.backups : this.databases;
    }

    public static StringList backupPaths(String db, Context ctx) {
        StringList sl = new StringList();
        for (IOFile f : ctx.mprop.dbpath().children()) {
            String name = f.name();
            if (!name.matches(db + "-\\d{4}-\\d{2}-\\d{2}-\\d{2}-\\d{2}-\\d{2}" + ".zip")) continue;
            sl.add(f.path());
        }
        return sl.sort(false, false);
    }
}

