/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.SortedMap;
import org.basex.core.Prop;
import org.basex.core.Text;
import org.basex.data.DataText;
import org.basex.gui.GUI;
import org.basex.gui.GUIConstants;
import org.basex.gui.GUIProp;
import org.basex.gui.layout.BaseXBack;
import org.basex.gui.layout.BaseXButton;
import org.basex.gui.layout.BaseXCombo;
import org.basex.gui.layout.BaseXDialog;
import org.basex.gui.layout.BaseXFileChooser;
import org.basex.gui.layout.BaseXLabel;
import org.basex.gui.layout.BaseXTextField;
import org.basex.gui.layout.TableLayout;
import org.basex.io.IOFile;
import org.basex.io.out.ArrayOutput;
import org.basex.io.serial.Serializer;
import org.basex.io.serial.SerializerProp;
import org.basex.util.Token;

public final class DialogExport
extends BaseXDialog {
    private static final String[] ENCODINGS;
    private final BaseXTextField path;
    private final BaseXLabel info;
    private final BaseXCombo method;
    private final BaseXCombo encoding;
    private final BaseXBack buttons;
    private final BaseXTextField params;

    public DialogExport(GUI main) {
        super(main, Text.EXPORT);
        BaseXBack p = new BaseXBack(new TableLayout(4, 1, 0, 0));
        p.add(new BaseXLabel(Text.OUTPUT_DIR + ":", true, true).border(0, 0, 6, 0));
        BaseXBack pp = new BaseXBack(new TableLayout(1, 2, 8, 0));
        this.path = new BaseXTextField(main.gprop.get(GUIProp.CREATEPATH), this);
        pp.add(this.path);
        BaseXButton browse = new BaseXButton(Text.BROWSE_D, this);
        browse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogExport.this.choose();
            }
        });
        pp.add(browse);
        p.add(pp);
        Prop prop = this.gui.context.prop;
        String exporter = prop.get(Prop.EXPORTER);
        SerializerProp sp = new SerializerProp(exporter);
        String[] methods = new String[DataText.METHODS.length - 1];
        for (int m = 0; m < methods.length; ++m) {
            methods[m] = DataText.METHODS[m].toUpperCase(Locale.ENGLISH);
        }
        this.method = new BaseXCombo(this, methods);
        this.method.setSelectedItem(sp.get(SerializerProp.S_METHOD).toUpperCase(Locale.ENGLISH));
        this.encoding = new BaseXCombo(this, ENCODINGS);
        String enc = this.gui.context.data().meta.encoding;
        boolean f = false;
        for (String s : ENCODINGS) {
            f |= s.equals(enc);
        }
        if (!f) {
            enc = enc.toUpperCase(Locale.ENGLISH);
            for (String s : ENCODINGS) {
                f |= s.equals(enc);
            }
        }
        this.encoding.setSelectedItem(f ? enc : sp.get(SerializerProp.S_ENCODING));
        this.params = new BaseXTextField(exporter, this);
        pp = new BaseXBack(new TableLayout(3, 2, 16, 6)).border(8, 0, 8, 0);
        pp.add(new BaseXLabel(Text.METHOD + ":", true, true));
        pp.add(this.method);
        pp.add(new BaseXLabel(Text.ENCODING + ":", true, true));
        pp.add(this.encoding);
        pp.add(new BaseXLabel(Text.PARAMETERS + ":", true, true));
        pp.add(this.params);
        p.add(pp);
        this.info = new BaseXLabel(" ").border(8, 0, 0, 0);
        p.add(this.info);
        this.set(p, "Center");
        pp = new BaseXBack(new BorderLayout());
        this.buttons = this.okCancel();
        pp.add((Component)this.buttons, "East");
        this.set(pp, "South");
        this.action(this.method);
        this.finish(null);
    }

    static BaseXCombo encoding(BaseXDialog dialog, String encoding) {
        BaseXCombo cb = new BaseXCombo(dialog, ENCODINGS);
        boolean f = false;
        String enc = encoding;
        for (String s : ENCODINGS) {
            f |= s.equals(enc);
        }
        if (!f) {
            enc = enc.toUpperCase(Locale.ENGLISH);
            for (String s : ENCODINGS) {
                f |= s.equals(enc);
            }
        }
        cb.setSelectedItem(enc);
        return cb;
    }

    void choose() {
        IOFile io = new BaseXFileChooser(Text.CHOOSE_DIR, this.path.getText(), this.gui).select(BaseXFileChooser.Mode.DOPEN);
        if (io != null) {
            this.path.setText(io.path());
        }
    }

    public String path() {
        return this.path.getText().trim();
    }

    @Override
    public void action(Object comp) {
        String pth;
        IOFile io;
        if (comp == this.method || comp == this.encoding) {
            StringBuilder sb = new StringBuilder();
            String meth = this.method.getSelectedItem().toString().toLowerCase(Locale.ENGLISH);
            boolean noxml = Token.eq(meth, "xml", "xhtml");
            DialogExport.add(sb, SerializerProp.S_METHOD, meth);
            if (DialogExport.add(sb, SerializerProp.S_ENCODING, this.encoding.getSelectedItem()) && noxml) {
                sb.append(',');
                sb.append(SerializerProp.S_OMIT_XML_DECLARATION[0]).append('=').append("no");
            }
            this.params.setText(sb.toString());
        }
        String inf = (io = new IOFile(pth = this.path())).isDir() && io.children().length > 0 ? Text.DIR_NOT_EMPTY : null;
        boolean bl = this.ok = !pth.isEmpty();
        if (this.ok) {
            this.gui.gprop.set(GUIProp.CREATEPATH, pth);
            if (comp == this.params) {
                try {
                    String par = this.params.getText();
                    Serializer.get(new ArrayOutput(), new SerializerProp(par));
                    this.gui.set(Prop.EXPORTER, par);
                }
                catch (IOException ex) {
                    this.ok = false;
                    inf = ex.getLocalizedMessage();
                }
            }
        }
        this.info.setText(inf, this.ok ? GUIConstants.Msg.WARN : GUIConstants.Msg.ERROR);
        DialogExport.enableOK(this.buttons, Text.B_OK, this.ok);
    }

    private static boolean add(StringBuilder sb, Object[] key, Object val) {
        if (Serializer.PROPS.get(key).equals(val)) {
            return false;
        }
        if (sb.length() != 0) {
            sb.append(',');
        }
        sb.append(key[0]).append('=').append(val);
        return true;
    }

    @Override
    public void close() {
        if (this.ok) {
            super.close();
        }
    }

    static {
        SortedMap<String, Charset> cs = Charset.availableCharsets();
        ENCODINGS = cs.keySet().toArray(new String[cs.size()]);
    }
}

