/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JProgressBar;
import javax.swing.Timer;
import org.basex.core.BaseXException;
import org.basex.core.Command;
import org.basex.core.Text;
import org.basex.gui.GUI;
import org.basex.gui.layout.BaseXBack;
import org.basex.gui.layout.BaseXButton;
import org.basex.gui.layout.BaseXDialog;
import org.basex.gui.layout.BaseXLabel;
import org.basex.gui.layout.BaseXLayout;
import org.basex.gui.layout.BaseXMem;
import org.basex.gui.layout.TableLayout;
import org.basex.util.Performance;
import org.basex.util.Util;

public final class DialogProgress
extends BaseXDialog
implements ActionListener {
    private static final int MAX = 600;
    private final Timer timer = new Timer(50, this);
    private BaseXLabel info;
    private BaseXMem mem;
    private Command command;
    private JProgressBar bar;

    private DialogProgress(GUI main, Command cmd) {
        super(main, "");
        this.init(main, cmd);
    }

    private DialogProgress(BaseXDialog dialog, Command cmd) {
        super(dialog, "");
        this.init(dialog, cmd);
    }

    private void init(Component parent, Command cmd) {
        this.info = new BaseXLabel(" ", true, true);
        this.set(this.info, "North");
        if (cmd.supportsProg()) {
            this.bar = new JProgressBar(0, 600);
            this.set(this.bar, "Center");
        } else {
            this.bar = null;
        }
        BaseXLayout.setWidth(this.info, 600);
        BaseXBack s = new BaseXBack(new BorderLayout()).border(10, 0, 0, 0);
        BaseXBack m = new BaseXBack(new TableLayout(1, 2, 5, 0));
        this.mem = new BaseXMem(this, false);
        m.add(new BaseXLabel(Text.MEMUSED_C));
        m.add(this.mem);
        s.add((Component)m, "West");
        if (cmd.stoppable()) {
            BaseXButton cancel = new BaseXButton(Text.B_CANCEL, this);
            s.add((Component)cancel, "East");
        }
        this.set(s, "South");
        this.command = cmd;
        this.timer.start();
        this.pack();
        this.setLocationRelativeTo(parent);
    }

    @Override
    public void cancel() {
        this.command.stop();
        this.close();
    }

    @Override
    public void close() {
        this.dispose();
    }

    @Override
    public void dispose() {
        this.timer.stop();
        super.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.setTitle(this.command.title());
        String detail = this.command.detail();
        this.info.setText(detail.isEmpty() ? " " : detail);
        this.mem.repaint();
        if (this.bar != null) {
            this.bar.setValue((int)(this.command.progress() * 600.0));
        }
    }

    public static void execute(BaseXDialog dialog, Command ... cmds) {
        DialogProgress.execute(dialog, null, cmds);
    }

    public static void execute(GUI gui, Command ... cmds) {
        DialogProgress.execute(gui, null, null, cmds);
    }

    public static void execute(BaseXDialog dialog, Runnable post, Command ... cmds) {
        DialogProgress.execute(dialog.gui, dialog, post, cmds);
    }

    public static void execute(final GUI gui, BaseXDialog dialog, Runnable post, Command ... cmds) {
        for (final Command cmd : cmds) {
            boolean newData = cmd.newData(gui.context);
            if (newData) {
                gui.notify.init();
            }
            final DialogProgress wait = dialog != null ? new DialogProgress(dialog, cmd) : new DialogProgress(gui, cmd);
            new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    String info;
                    Performance perf = new Performance();
                    gui.updating = cmd.updating(gui.context);
                    boolean ok = true;
                    try {
                        cmd.execute(gui.context);
                        info = cmd.info();
                    }
                    catch (BaseXException ex) {
                        ok = false;
                        info = ex.getMessage();
                    }
                    finally {
                        gui.updating = false;
                    }
                    String time = perf.toString();
                    gui.info.setInfo(info, cmd, time, ok);
                    gui.info.reset();
                    gui.status.setText(Util.info(Text.TIME_NEEDED_X, time));
                    wait.dispose();
                    if (!ok) {
                        BaseXDialog.error(gui, info.equals(Text.INTERRUPTED) ? Text.COMMAND_CANCELED : info);
                    }
                }
            }.start();
            wait.setVisible(true);
            if (newData) {
                gui.notify.init();
                continue;
            }
            if (!cmd.updating(gui.context)) continue;
            gui.notify.update();
        }
        if (dialog != null) {
            dialog.action(dialog);
        }
        if (post != null) {
            post.run();
        }
    }
}

