/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import org.basex.gui.layout.BaseXBack;
import org.basex.gui.layout.BaseXSplitSep;

public final class BaseXSplit
extends BaseXBack
implements LayoutManager {
    private final boolean l;
    private double[] s;
    private double[] t;
    private double d;

    public BaseXSplit(boolean lay) {
        this.layout(this);
        this.l = lay;
    }

    @Override
    public Component add(Component comp) {
        if (this.getComponentCount() != 0) {
            super.add(new BaseXSplitSep(this.l));
        }
        super.add(comp);
        this.s = null;
        return comp;
    }

    @Override
    public void removeAll() {
        super.removeAll();
        this.s = null;
    }

    void startDrag(double p) {
        this.d = p;
        this.t = (double[])this.s.clone();
    }

    void drag(BaseXSplitSep sep, double p) {
        int i;
        Component[] m = this.getComponents();
        int r = this.s.length;
        int q = 0;
        for (int n = 0; n < r - 1; ++n) {
            if (m[(n << 1) + 1] != sep) continue;
            q = n + 1;
        }
        double v = (this.d - p) / (double)(this.l ? this.getWidth() : this.getHeight());
        for (i = 0; i < q; ++i) {
            if (!(this.t[i] - v / (double)q < 1.0E-4)) continue;
            return;
        }
        for (i = q; i < r; ++i) {
            if (!(this.t[i] + v / (double)(r - q) < 1.0E-4)) continue;
            return;
        }
        for (i = 0; i < q; ++i) {
            this.s[i] = this.t[i] - v / (double)q;
        }
        for (i = q; i < r; ++i) {
            this.s[i] = this.t[i] + v / (double)(r - q);
        }
        this.revalidate();
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        return this.getSize();
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return this.preferredLayoutSize(parent);
    }

    @Override
    public void layoutContainer(Container parent) {
        boolean a;
        Component[] c = this.getComponents();
        int h = this.getHeight();
        int w = this.getWidth();
        int m = c.length + 1 >> 1;
        double p = (this.l ? w : h) - (m - 1) * 6;
        boolean bl = a = this.s == null;
        if (a) {
            this.s = new double[m];
        }
        double v = 0.0;
        for (int n = 0; n < c.length; ++n) {
            boolean b = (n & 1) == 0;
            double z = 6.0;
            if (b) {
                z = this.s[n >> 1] == 0.0 ? (double)((int)(p / (double)m)) : this.s[n >> 1] * p;
            }
            int y = (int)v;
            c[n].setBounds(this.l ? y : 0, this.l ? 0 : y, this.l ? (int)z : w, this.l ? h : (int)z);
            if (a && b) {
                this.s[n >> 1] = z / p;
            }
            v += z;
        }
    }
}

