/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.view;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import org.basex.gui.AGUI;
import org.basex.gui.GUIConstants;
import org.basex.gui.layout.BaseXLayout;
import org.basex.gui.layout.BaseXPanel;
import org.basex.gui.view.ViewContainer;
import org.basex.gui.view.ViewPanel;

final class ViewMover
extends BaseXPanel {
    private static final int SIZE = 9;
    private boolean active;

    ViewMover(AGUI main) {
        super(main);
        this.setLayout(new BorderLayout());
        BaseXLayout.setHeight(this, 9);
        this.addKeyListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setCursor(GUIConstants.CURSORMOVE);
    }

    @Override
    public void paintComponent(Graphics g) {
        int w = this.getWidth();
        int h = this.getHeight();
        g.setColor(GUIConstants.color(this.active ? 4 : 1));
        g.fillRect(0, 0, w, h);
        g.setColor(GUIConstants.color(this.active ? 20 : 10));
        for (int x = -2; x < w; x += 4) {
            g.drawLine(x + 4, 1, x, h - 2);
        }
        g.drawRect(0, 0, w - 1, h - 1);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        ViewPanel view = (ViewPanel)this.getParent();
        Container comp = view;
        while (!((comp = comp.getParent()) instanceof ViewContainer)) {
        }
        Point a = this.getLocationOnScreen();
        Point b = comp.getLocationOnScreen();
        Point c = new Point(a.x - b.x + e.getX(), a.y - b.y + e.getY());
        ((ViewContainer)comp).dragPanel(view, c);
        this.active = true;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.active = true;
        this.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (!this.active) {
            return;
        }
        Container comp = this;
        while (!((comp = comp.getParent()) instanceof ViewContainer)) {
        }
        ((ViewContainer)comp).dropPanel();
        this.active = false;
        this.repaint();
    }
}

