/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io;

import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Locale;
import org.basex.io.IOContent;
import org.basex.io.IOFile;
import org.basex.io.IOUrl;
import org.basex.util.Token;
import org.xml.sax.InputSource;

public abstract class IO {
    public static final String BASEXSUFFIX = ".basex";
    public static final String XQSUFFIX = ".xq";
    public static final String XQMSUFFIX = ".xqm";
    public static final String XMLSUFFIX = ".xml";
    public static final String ZIPSUFFIX = ".zip";
    public static final String CSVSUFFIX = ".csv";
    public static final String JSONSUFFIX = ".json";
    public static final String JARSUFFIX = ".jar";
    public static final String GZSUFFIX = ".gz";
    public static final String XARSUFFIX = ".xar";
    public static final String FILEPREF = "file:";
    public static final SimpleDateFormat DATE = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss");
    public static final String DATEPATTERN = "-\\d{4}-\\d{2}-\\d{2}-\\d{2}-\\d{2}-\\d{2}";
    public static final String[] XQSUFFIXES = new String[]{".xq", ".xqm", ".xqy", ".xql", ".xqu", ".xquery"};
    public static final String[] ZIPSUFFIXES = new String[]{".zip", ".gz", ".xar", ".docx", ".pptx", ".xslx", ".odt", ".odp", ".ods"};
    public static final String[] XMLSUFFIXES = new String[]{".xml", ".xsd", ".xsl", ".xslt", ".svg", ".rdf", ".rss", ".rng", ".sch"};
    public static final String[] HTMLSUFFIXES = new String[]{".xhtml", ".html", ".htm"};
    public static final String[] TXTSUFFIXES = new String[]{".txt", ".text", ".ini", ".conf"};
    public static final int BLOCKSIZE = 4096;
    public static final int NODEPOWER = 4;
    public static final int NODESIZE = 16;
    public static final int ENTRIES = 256;
    public static final int MAXATTS = 31;
    public static final long OFFNUM = 0x8000000000L;
    public static final long OFFCOMP = 0x4000000000L;
    String path;
    String name;
    long len = -1L;

    IO(String p) {
        this.init(p);
    }

    final void init(String p) {
        this.path = p;
        String n = p.substring(p.lastIndexOf(47) + 1);
        this.name = n.isEmpty() ? Long.toString(System.currentTimeMillis()) + XMLSUFFIX : n;
    }

    public static IO get(String source) {
        if (source == null) {
            return new IOContent(Token.EMPTY);
        }
        String s = source.trim();
        return s.indexOf(60) == 0 ? new IOContent(s) : (IOUrl.isFileURL(s) ? new IOFile(IOUrl.file(s)) : (IOFile.isValid(s) ? new IOFile(s) : (IOUrl.isValid(s) ? new IOUrl(s) : new IOContent(s))));
    }

    public abstract byte[] read() throws IOException;

    public boolean exists() {
        return true;
    }

    public boolean isDir() {
        return false;
    }

    public boolean hasSuffix(String ... suffixes) {
        int i = this.path.lastIndexOf(46);
        if (i == -1) {
            return false;
        }
        String suf = this.path.substring(i).toLowerCase(Locale.ENGLISH);
        for (String z : suffixes) {
            if (!suf.equals(z)) continue;
            return true;
        }
        return false;
    }

    public long timeStamp() {
        return System.currentTimeMillis();
    }

    public void length(long l) {
        this.len = l;
    }

    public long length() {
        return this.len;
    }

    public abstract InputSource inputSource();

    public abstract InputStream inputStream() throws IOException;

    public IO merge(String in) {
        return IO.get(in);
    }

    public final boolean isArchive() {
        return this.hasSuffix(ZIPSUFFIXES);
    }

    public final String dbname() {
        String n = this.name();
        int i = n.lastIndexOf(46);
        return (i != -1 ? n.substring(0, i) : n).replaceAll("[^\\w-]", "");
    }

    public final String name() {
        return this.name;
    }

    public final void name(String n) {
        this.name = n;
        if (this.path.isEmpty()) {
            this.path = n;
        }
    }

    public final String path() {
        return this.path;
    }

    public String url() {
        return this.path;
    }

    public String dir() {
        return "";
    }

    public final boolean eq(IO io) {
        return this.path.equals(io.path);
    }

    public String toString() {
        return this.path;
    }

    public static String suffix(String path) {
        int s = path.lastIndexOf(47);
        int d = path.lastIndexOf(46);
        return d <= s ? "" : path.substring(d + 1).toLowerCase(Locale.ENGLISH);
    }
}

