/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.serial;

import java.io.IOException;
import java.io.OutputStream;
import org.basex.io.serial.OutputSerializer;
import org.basex.io.serial.SerializerProp;
import org.basex.query.util.Err;
import org.basex.query.value.item.Item;
import org.basex.util.Token;
import org.basex.util.Util;

public final class JsonMLSerializer
extends OutputSerializer {
    private boolean att;

    public JsonMLSerializer(OutputStream os, SerializerProp props) throws IOException {
        super(os, props, new String[0]);
    }

    @Override
    protected void startOpen(byte[] name) throws IOException {
        if (this.level != 0) {
            this.print(44);
            this.indent();
        }
        this.print(91);
        this.print(34);
        for (byte ch : Token.local(name)) {
            this.code(ch);
        }
        this.print(34);
        this.att = false;
    }

    @Override
    public void attribute(byte[] name, byte[] value) throws IOException {
        this.print(", ");
        if (!this.att) {
            this.print("{");
            this.att = true;
        }
        this.print(34);
        for (byte ch : name) {
            this.code(ch);
        }
        this.print("\":\"");
        for (byte ch : value) {
            this.code(ch);
        }
        this.print("\"");
    }

    @Override
    public void namespace(byte[] n, byte[] v) throws IOException {
    }

    @Override
    protected void finishOpen() throws IOException {
        if (this.att) {
            this.print("}");
        }
    }

    @Override
    public void finishText(byte[] text) throws IOException {
        this.print(44);
        this.indent();
        this.print(34);
        for (byte ch : text) {
            this.code(ch);
        }
        this.print(34);
    }

    @Override
    protected void finishEmpty() throws IOException {
        this.finishOpen();
        this.print(93);
    }

    @Override
    protected void finishClose() throws IOException {
        this.print(93);
    }

    @Override
    protected void code(int ch) throws IOException {
        switch (ch) {
            case 8: {
                this.print("\\b");
                break;
            }
            case 12: {
                this.print("\\f");
                break;
            }
            case 10: {
                this.print("\\n");
                break;
            }
            case 13: {
                this.print("\\r");
                break;
            }
            case 9: {
                this.print("\\t");
                break;
            }
            case 34: {
                this.print("\\\"");
                break;
            }
            case 47: {
                this.print("\\/");
                break;
            }
            case 92: {
                this.print("\\\\");
                break;
            }
            default: {
                this.print(ch);
            }
        }
    }

    @Override
    public void finishComment(byte[] value) throws IOException {
    }

    @Override
    public void finishPi(byte[] name, byte[] value) throws IOException {
    }

    @Override
    public void atomic(Item value) throws IOException {
        JsonMLSerializer.error("Atomic values cannot be serialized", new Object[0]);
    }

    private static void error(String msg, Object ... ext) throws IOException {
        throw Err.BXJS_SER.thrwSerial(new Object[]{Util.inf(msg, ext)});
    }
}

