/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Arr;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Or;
import org.basex.query.func.Function;
import org.basex.query.func.StandardFunc;
import org.basex.query.iter.Iter;
import org.basex.query.util.IndexContext;
import org.basex.query.util.Var;
import org.basex.query.value.Value;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.FElem;
import org.basex.query.value.type.SeqType;
import org.basex.util.InputInfo;
import org.basex.util.list.StringList;

public final class If
extends Arr {
    private Expr cond;

    public If(InputInfo ii, Expr c, Expr t, Expr e) {
        super(ii, t, e);
        this.cond = c;
    }

    @Override
    public void checkUp() throws QueryException {
        this.checkNoUp(this.cond);
        this.checkAllUp(this.expr);
    }

    @Override
    public Expr compile(QueryContext ctx) throws QueryException {
        this.cond = this.cond.compile(ctx).compEbv(ctx);
        if (this.cond.isValue()) {
            return this.optPre(this.eval(ctx).compile(ctx), ctx);
        }
        super.compile(ctx);
        if (this.expr[0].sameAs(this.expr[1])) {
            return this.optPre(this.expr[0], ctx);
        }
        if (this.cond.isFunction(Function.NOT)) {
            ctx.compInfo("rewriting %", this);
            this.cond = ((StandardFunc)this.cond).expr[0];
            Expr tmp = this.expr[0];
            this.expr[0] = this.expr[1];
            this.expr[1] = tmp;
        }
        if (this.expr[0] == Bln.TRUE && this.expr[1] == Bln.FALSE) {
            ctx.compInfo("rewriting %", this);
            return this.compBln(this.cond);
        }
        if (this.expr[0].type().eq(SeqType.BLN) && this.expr[1] == Bln.TRUE) {
            ctx.compInfo("rewriting %", this);
            StandardFunc e = Function.NOT.get(this.info, this.cond);
            return this.expr[0] == Bln.FALSE ? e : new Or(this.info, e, this.expr[0]);
        }
        this.type = this.expr[0].type().intersect(this.expr[1].type());
        return this;
    }

    @Override
    public Iter iter(QueryContext ctx) throws QueryException {
        return ctx.iter(this.eval(ctx));
    }

    @Override
    public Value value(QueryContext ctx) throws QueryException {
        return ctx.value(this.eval(ctx));
    }

    @Override
    public Item item(QueryContext ctx, InputInfo ii) throws QueryException {
        return this.eval(ctx).item(ctx, this.info);
    }

    private Expr eval(QueryContext ctx) throws QueryException {
        return this.expr[this.cond.ebv(ctx, this.info).bool(this.info) ? 0 : 1];
    }

    @Override
    public boolean uses(Expr.Use u) {
        return this.cond.uses(u) || super.uses(u);
    }

    @Override
    public int count(Var v) {
        return this.cond.count(v) + super.count(v);
    }

    @Override
    public boolean removable(Var v) {
        return this.cond.removable(v) && super.removable(v);
    }

    @Override
    public Expr remove(Var v) {
        this.cond = this.cond.remove(v);
        return super.remove(v);
    }

    @Override
    public boolean databases(StringList db) {
        return this.cond.databases(db) && super.databases(db);
    }

    @Override
    public Expr indexEquivalent(IndexContext ic) throws QueryException {
        for (int e = 0; e < this.expr.length; ++e) {
            this.expr[e] = this.expr[e].indexEquivalent(ic);
        }
        return this;
    }

    @Override
    public boolean isVacuous() {
        return this.expr[0].isVacuous() || this.expr[1].isVacuous();
    }

    @Override
    public Expr markTailCalls() {
        this.expr[0] = this.expr[0].markTailCalls();
        this.expr[1] = this.expr[1].markTailCalls();
        return this;
    }

    @Override
    public void plan(FElem plan) {
        this.addPlan(plan, this.planElem(new Object[0]), new Object[]{this.cond, this.expr});
    }

    @Override
    public String toString() {
        return "if(" + this.cond + ") " + "then" + ' ' + this.expr[0] + ' ' + "else" + ' ' + this.expr[1];
    }
}

