/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import java.util.Locale;
import org.basex.data.Data;
import org.basex.index.Index;
import org.basex.index.IndexType;
import org.basex.index.name.Names;
import org.basex.index.path.PathNode;
import org.basex.index.query.EntryIterator;
import org.basex.index.query.IndexEntries;
import org.basex.index.stats.Stats;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.expr.Expr;
import org.basex.query.func.Function;
import org.basex.query.func.StandardFunc;
import org.basex.query.iter.Iter;
import org.basex.query.util.Err;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.item.Str;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.FDoc;
import org.basex.query.value.node.FElem;
import org.basex.query.value.type.NodeType;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.list.StringList;

public final class FNIndex
extends StandardFunc {
    static final QNm Q_NAME = new QNm(QueryText.NAM);
    static final QNm Q_COUNT = new QNm(QueryText.COUNT);
    static final QNm Q_TYPE = new QNm(QueryText.TYP);
    static final QNm Q_ENTRY = new QNm("entry");
    static final QNm Q_MIN = new QNm(QueryText.MIN);
    static final QNm Q_MAX = new QNm(QueryText.MAX);
    static final QNm Q_ELM = new QNm(NodeType.ELM.string());
    static final QNm Q_ATT = new QNm(NodeType.ATT.string());
    static final byte[] FLAT = Token.token("flat");

    public FNIndex(InputInfo ii, Function f, Expr ... e) {
        super(ii, f, e);
    }

    @Override
    public Item item(QueryContext ctx, InputInfo ii) throws QueryException {
        switch (this.sig) {
            case _INDEX_FACETS: {
                return this.facets(ctx);
            }
        }
        return super.item(ctx, ii);
    }

    @Override
    public Iter iter(QueryContext ctx) throws QueryException {
        switch (this.sig) {
            case _INDEX_TEXTS: {
                return this.values(ctx, IndexType.TEXT);
            }
            case _INDEX_ATTRIBUTES: {
                return this.values(ctx, IndexType.ATTRIBUTE);
            }
            case _INDEX_ELEMENT_NAMES: {
                return this.names(ctx, IndexType.TAG);
            }
            case _INDEX_ATTRIBUTE_NAMES: {
                return this.names(ctx, IndexType.ATTNAME);
            }
        }
        return super.iter(ctx);
    }

    private Item facets(QueryContext ctx) throws QueryException {
        Data data = this.data(0, ctx);
        boolean flat = this.expr.length == 2 && Token.eq(this.checkStr(this.expr[1], ctx), FLAT);
        return new FDoc(Token.EMPTY).add(flat ? FNIndex.flat(data) : FNIndex.tree(data, data.paths.root().get(0)));
    }

    private Iter values(QueryContext ctx, IndexType it) throws QueryException {
        byte[] entry;
        Data data = this.data(0, ctx);
        byte[] byArray = entry = this.expr.length < 2 ? Token.EMPTY : this.checkStr(this.expr[1], ctx);
        if (data.inMemory()) {
            Err.BXDB_MEM.thrw(this.info, data.meta.name);
        }
        IndexEntries et = this.expr.length < 3 ? new IndexEntries(entry, it) : new IndexEntries(entry, this.checkBln(this.expr[2], ctx), it);
        return FNIndex.entries(data, et, this);
    }

    static Iter entries(Data data, IndexEntries entries, StandardFunc call) throws QueryException {
        boolean avl;
        Index index;
        IndexType it = entries.type();
        if (it == IndexType.TEXT) {
            index = data.txtindex;
            avl = data.meta.textindex;
        } else if (it == IndexType.ATTRIBUTE) {
            index = data.atvindex;
            avl = data.meta.attrindex;
        } else {
            index = data.ftxindex;
            avl = data.meta.ftxtindex;
        }
        if (!avl) {
            Err.BXDB_INDEX.thrw(call.info, data.meta.name, it.toString().toLowerCase(Locale.ENGLISH));
        }
        return FNIndex.entries(index, entries);
    }

    private Iter names(QueryContext ctx, IndexType it) throws QueryException {
        Data data = this.data(0, ctx);
        return FNIndex.entries(it == IndexType.TAG ? data.tagindex : data.atnindex, new IndexEntries(Token.EMPTY, it));
    }

    private static Iter entries(final Index index, final IndexEntries entries) {
        return new Iter(){
            final EntryIterator ei;
            {
                this.ei = index.entries(entries);
            }

            @Override
            public ANode next() {
                byte[] token = this.ei.next();
                if (token == null) {
                    return null;
                }
                FElem elem = new FElem(Q_ENTRY).add(Q_COUNT, Token.token(this.ei.count())).add(token);
                return elem;
            }
        };
    }

    private static FElem flat(Data data) {
        FElem elem = new FElem(new QNm(NodeType.DOC.string()));
        FNIndex.index(data.tagindex, Q_ELM, elem);
        FNIndex.index(data.atnindex, Q_ATT, elem);
        return elem;
    }

    private static void index(Names names, QNm name, FElem root) {
        for (int i = 0; i < names.size(); ++i) {
            FElem sub = new FElem(name).add(Q_NAME, names.key(i + 1));
            FNIndex.stats(names.stat(i + 1), sub);
            root.add(sub);
        }
    }

    private static FElem tree(Data data, PathNode root) {
        Names names;
        FElem elem = new FElem(new QNm(ANode.type(root.kind).string()));
        boolean elm = root.kind == 1;
        Names names2 = names = elm ? data.tagindex : data.atnindex;
        if (root.kind == 3 || elm) {
            elem.add(Q_NAME, names.key(root.name));
        }
        FNIndex.stats(root.stats, elem);
        for (PathNode p : root.ch) {
            elem.add(FNIndex.tree(data, p));
        }
        return elem;
    }

    private static void stats(Stats stats, FElem elem) {
        String k = stats.type.toString().toLowerCase(Locale.ENGLISH);
        elem.add(Q_TYPE, Token.token(k));
        elem.add(Q_COUNT, Token.token(stats.count));
        switch (stats.type) {
            case CATEGORY: {
                for (byte[] c : stats.cats) {
                    FElem sub = new FElem(Q_ENTRY);
                    sub.add(Q_COUNT, Token.token(stats.cats.value(c))).add(c);
                    elem.add(sub);
                }
                break;
            }
            case DOUBLE: 
            case INTEGER: {
                elem.add(Q_MIN, Token.token(stats.min));
                elem.add(Q_MAX, Token.token(stats.max));
                break;
            }
        }
    }

    @Override
    public boolean uses(Expr.Use u) {
        return u == Expr.Use.CTX && (this.sig == Function._INDEX_TEXTS || this.sig == Function._INDEX_ATTRIBUTES) || super.uses(u);
    }

    @Override
    public boolean databases(StringList db) {
        if (!(this.expr[0] instanceof Str)) {
            return false;
        }
        db.add(Token.string(((Str)this.expr[0]).string()));
        return true;
    }
}

