/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import org.basex.io.IOFile;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.func.Function;
import org.basex.query.func.StandardFunc;
import org.basex.query.iter.Iter;
import org.basex.query.iter.NodeSeqBuilder;
import org.basex.query.util.pkg.Package;
import org.basex.query.util.pkg.RepoManager;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.FElem;
import org.basex.util.InputInfo;
import org.basex.util.Token;

public final class FNRepo
extends StandardFunc {
    private static final QNm Q_PACKAGE = new QNm("package");
    private static final QNm Q_NAME = new QNm("name");
    private static final QNm Q_TYPE = new QNm("type");
    private static final QNm Q_VERSION = new QNm("version");

    protected FNRepo(InputInfo ii, Function f, Expr[] e) {
        super(ii, f, e);
    }

    @Override
    public Iter iter(QueryContext ctx) throws QueryException {
        switch (this.sig) {
            case _REPO_LIST: {
                return FNRepo.list(ctx);
            }
        }
        return super.iter(ctx);
    }

    @Override
    public Item item(QueryContext ctx, InputInfo ii) throws QueryException {
        this.checkCreate(ctx);
        RepoManager rm = new RepoManager(ctx.context, ii);
        byte[] pkg = this.expr.length == 0 ? null : this.checkStr(this.expr[0], ctx);
        switch (this.sig) {
            case _REPO_INSTALL: {
                rm.install(pkg);
                return null;
            }
            case _REPO_DELETE: {
                rm.delete(pkg);
                return null;
            }
        }
        return super.item(ctx, ii);
    }

    private static Iter list(QueryContext ctx) {
        NodeSeqBuilder cache = new NodeSeqBuilder();
        for (byte[] p : ctx.context.repo.pkgDict()) {
            if (p == null) continue;
            FElem elem = new FElem(Q_PACKAGE);
            elem.add(Q_NAME, Package.name(p));
            elem.add(Q_VERSION, Package.version(p));
            elem.add(Q_TYPE, Token.token("EXPath"));
            cache.add(elem);
        }
        for (IOFile dir : ctx.context.repo.path().children()) {
            if (dir.name().indexOf(45) != -1) continue;
            for (String s : dir.descendants()) {
                FElem elem = new FElem(Q_PACKAGE);
                String n = dir.name() + '.' + s.replaceAll("\\..*", "").replace('/', '.');
                elem.add(Q_NAME, Token.token(n));
                elem.add(Q_TYPE, Token.token("Internal"));
                cache.add(elem);
            }
        }
        return cache;
    }

    @Override
    public boolean uses(Expr.Use u) {
        return u == Expr.Use.CTX || super.uses(u);
    }
}

