/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.basex.io.IO;
import org.basex.io.IOContent;
import org.basex.io.out.ArrayOutput;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.expr.Expr;
import org.basex.query.func.FuncParams;
import org.basex.query.func.Function;
import org.basex.query.func.StandardFunc;
import org.basex.query.util.Err;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.item.Str;
import org.basex.query.value.node.DBNode;
import org.basex.query.value.type.Type;
import org.basex.util.InputInfo;
import org.basex.util.Reflect;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.hash.TokenMap;

public final class FNXslt
extends StandardFunc {
    private static final QNm E_PARAM = new QNm("parameters", QueryText.XSLTURI);
    private static final String[] IMPL = new String[]{"", "Java", "1.0", "net.sf.saxon.TransformerFactoryImpl", "Saxon HE", "2.0", "com.saxonica.config.ProfessionalTransformerFactory", "Saxon PE", "2.0", "com.saxonica.config.EnterpriseTransformerFactory", "Saxon EE", "2.0"};
    private static final int OFFSET;

    static String get(boolean name) {
        return IMPL[OFFSET + (name ? 1 : 2)];
    }

    public FNXslt(InputInfo ii, Function f, Expr ... e) {
        super(ii, f, e);
    }

    @Override
    public Item item(QueryContext ctx, InputInfo ii) throws QueryException {
        switch (this.sig) {
            case _XSLT_PROCESSOR: {
                return Str.get(FNXslt.get(true));
            }
            case _XSLT_VERSION: {
                return Str.get(FNXslt.get(false));
            }
            case _XSLT_TRANSFORM: {
                return this.transform(ctx);
            }
        }
        return super.item(ctx, ii);
    }

    private Item transform(QueryContext ctx) throws QueryException {
        this.checkCreate(ctx);
        try {
            IO in = this.read(this.expr[0], ctx);
            IO xsl = this.read(this.expr[1], ctx);
            Item opt = this.expr.length > 2 ? this.expr[2].item(ctx, this.info) : null;
            TokenMap map = new FuncParams(E_PARAM, this.info).parse(opt);
            byte[] result = FNXslt.transform(in, xsl, map);
            return new DBNode(new IOContent(result), ctx.context.prop);
        }
        catch (QueryException ex) {
            throw ex;
        }
        catch (Exception ex) {
            Util.debug(ex);
            throw Err.IOERR.thrw(this.info, ex instanceof InvocationTargetException ? ex.getCause() : ex);
        }
    }

    private IO read(Expr e, QueryContext ctx) throws QueryException, IOException {
        Item it = this.checkNoEmpty(e.item(ctx, this.info));
        Type ip = it.type;
        if (ip.isNode()) {
            return new IOContent(it.serialize().toArray());
        }
        if (ip.isString()) {
            return IO.get(Token.string(it.string(this.info)));
        }
        throw Err.STRNODTYPE.thrw(this.info, this, ip);
    }

    @Override
    public boolean uses(Expr.Use u) {
        return u == Expr.Use.NDT && this.sig == Function._XSLT_TRANSFORM || super.uses(u);
    }

    private static byte[] transform(IO in, IO xsl, TokenMap par) throws TransformerException, IOException {
        TransformerFactory tc = TransformerFactory.newInstance();
        Transformer tr = tc.newTransformer(new StreamSource(new ByteArrayInputStream(xsl.read())));
        for (byte[] key : par) {
            tr.setParameter(Token.string(key), Token.string(par.get(key)));
        }
        ArrayOutput ao = new ArrayOutput();
        tr.transform(new StreamSource(new ByteArrayInputStream(in.read())), new StreamResult(ao));
        return ao.toArray();
    }

    static {
        String fac = TransformerFactory.class.getName();
        String impl = System.getProperty(fac);
        if (System.getProperty(fac) != null) {
            FNXslt.IMPL[1] = impl;
            FNXslt.IMPL[2] = "Unknown";
            OFFSET = 0;
        } else {
            int s;
            for (s = IMPL.length - 3; s != 0 && Reflect.find(IMPL[s]) == null; s -= 3) {
            }
            OFFSET = s;
            if (s != 0) {
                System.setProperty(fac, IMPL[s]);
            }
        }
    }
}

