/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.iter;

import java.io.IOException;
import org.basex.data.Result;
import org.basex.io.out.ArrayOutput;
import org.basex.io.serial.Serializer;
import org.basex.query.iter.ValueIter;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.Seq;
import org.basex.util.Util;

public final class ValueBuilder
extends ValueIter
implements Result {
    public Item[] item;
    private int size;
    private int pos = -1;

    public ValueBuilder() {
        this(1);
    }

    public ValueBuilder(int c) {
        this.item = new Item[c];
    }

    public ValueBuilder(Item[] it, int s) {
        this.item = it;
        this.size = s;
    }

    public void add(Value val) {
        long sz = val.size();
        while ((long)(this.item.length - this.size) < sz) {
            this.item = ValueBuilder.extend(this.item);
        }
        this.size += val.writeTo(this.item, this.size);
    }

    public void add(Item it) {
        if (this.size == this.item.length) {
            this.item = ValueBuilder.extend(this.item);
        }
        this.item[this.size++] = it;
    }

    @Override
    public boolean sameAs(Result v) {
        if (!(v instanceof ValueBuilder)) {
            return false;
        }
        ValueBuilder vb = (ValueBuilder)v;
        if (this.size != vb.size) {
            return false;
        }
        for (int i = 0; i < this.size; ++i) {
            if (this.item[i].type == vb.item[i].type && this.item[i].sameAs(vb.item[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public void serialize(Serializer ser) throws IOException {
        for (int c = 0; c < this.size && !ser.finished(); ++c) {
            this.serialize(ser, c);
        }
    }

    @Override
    public void serialize(Serializer ser, int n) throws IOException {
        ser.serialize(this.item[n]);
    }

    @Override
    public Item next() {
        return ++this.pos < this.size ? this.item[this.pos] : null;
    }

    public void size(int s) {
        this.size = s;
    }

    @Override
    public boolean reset() {
        this.pos = -1;
        return true;
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public Item get(long i) {
        return this.item[(int)i];
    }

    public void set(Item i, int p) {
        this.item[p] = i;
    }

    @Override
    public Value value() {
        return Seq.get(this.item, this.size);
    }

    @Override
    public ArrayOutput serialize() throws IOException {
        ArrayOutput ao = new ArrayOutput();
        this.serialize(Serializer.get(ao));
        return ao;
    }

    public String toString() {
        try {
            return this.serialize().toString();
        }
        catch (IOException ex) {
            throw Util.notexpected(ex);
        }
    }
}

