/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.up.primitives;

import java.util.ArrayList;
import org.basex.data.Data;
import org.basex.data.MemData;
import org.basex.query.QueryException;
import org.basex.query.up.NamePool;
import org.basex.query.up.primitives.PrimitiveType;
import org.basex.query.up.primitives.StructuralUpdate;
import org.basex.query.util.ANodeList;
import org.basex.query.util.DataBuilder;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.FTxt;
import org.basex.query.value.type.NodeType;
import org.basex.util.InputInfo;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;

public abstract class NodeCopy
extends StructuralUpdate {
    ArrayList<ANodeList> insert = new ArrayList(1);
    MemData md;
    int size;

    NodeCopy(PrimitiveType t, int p, Data d, InputInfo i, ANodeList n) {
        super(t, p, d, i);
        this.insert.add(n);
    }

    public void prepare() throws QueryException {
        this.md = new MemData(this.data);
        ANodeList seq = new ANodeList();
        for (int i = 0; i < this.insert.size(); ++i) {
            ANodeList nl = this.insert.get(i);
            int ns = nl.size();
            for (int n = 0; n < ns; ++n) {
                seq.add(nl.get(n));
            }
            this.size += ns;
            this.insert.set(i, null);
        }
        this.insert = null;
        new DataBuilder(this.md).build(NodeCopy.mergeNodeCacheText(seq));
    }

    final void add(NamePool pool) {
        for (int p = 0; p < this.md.meta.size; ++p) {
            int k = this.md.kind(p);
            if (k != 3 && k != 1 || this.md.parent(p, k) > -1) continue;
            int u = this.md.uri(p, k);
            QNm qnm = new QNm(this.md.name(p, k));
            if (u != 0) {
                qnm.uri(this.md.nspaces.uri(u));
            }
            pool.add(qnm, ANode.type(k));
        }
    }

    private static ANodeList mergeNodeCacheText(ANodeList nl) {
        int ns = nl.size();
        ANodeList s = new ANodeList(ns);
        if (ns == 0) {
            return s;
        }
        ANode n = nl.get(0);
        int c = 0;
        while (c < ns) {
            if (n.type == NodeType.TXT) {
                TokenBuilder tb = new TokenBuilder();
                while (n.type == NodeType.TXT) {
                    tb.add(n.string());
                    if (++c == ns) break;
                    n = nl.get(c);
                }
                s.add(new FTxt(tb.finish()));
                continue;
            }
            s.add(n);
            if (++c >= ns) continue;
            n = nl.get(c);
        }
        return s;
    }

    @Override
    public final int size() {
        return this.size;
    }

    public String toString() {
        return Util.name(this) + '[' + this.targetNode() + ", " + this.size() + " ops]";
    }
}

