/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.expr.Expr;
import org.basex.query.expr.ParseExpr;
import org.basex.query.iter.Iter;
import org.basex.query.util.Ann;
import org.basex.query.util.Err;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.FElem;
import org.basex.query.value.type.SeqType;
import org.basex.util.InputInfo;
import org.basex.util.TokenBuilder;
import org.basex.util.list.StringList;

public final class Var
extends ParseExpr {
    public final QNm name;
    public final Ann ann;
    private final int id;
    public SeqType ret;
    public boolean global;
    public boolean declared;
    private Value value;
    private Expr expr;

    private Var(InputInfo ii, QNm n, SeqType t, int i, Ann a) {
        super(ii);
        this.name = n;
        this.type = t;
        this.id = i;
        this.ann = a == null ? new Ann() : a;
    }

    public static Var create(QueryContext ctx, InputInfo ii, QNm n, SeqType t, Ann a) {
        return new Var(ii, n, t, ctx.varIDs++, a);
    }

    public static Var create(QueryContext ctx, InputInfo ii, QNm n, Ann a) {
        return Var.create(ctx, ii, n, null, a);
    }

    @Override
    public void checkUp() throws QueryException {
        this.checkNoUp(this.expr);
    }

    @Override
    public Var compile(QueryContext ctx) throws QueryException {
        if (this.expr != null) {
            this.bind(this.expr.compile(ctx), ctx);
        }
        return this;
    }

    public void reset(SeqType t, QueryContext ctx) throws QueryException {
        this.type = t;
        if (this.value != null && !this.value.type.instanceOf(t.type) && this.value instanceof Item) {
            this.value = this.type.type.cast((Item)this.value, ctx, this.info);
        }
    }

    public Var bind(Expr e, QueryContext ctx) throws QueryException {
        this.expr = e;
        return e.isValue() ? this.bind((Value)e, ctx) : this;
    }

    public Expr expr() {
        return this.expr;
    }

    public Var bind(Value v, QueryContext ctx) throws QueryException {
        this.expr = v;
        this.value = this.cast(v, ctx);
        return this;
    }

    @Override
    public Item item(QueryContext ctx, InputInfo ii) throws QueryException {
        return this.value(ctx).item(ctx, ii);
    }

    @Override
    public Iter iter(QueryContext ctx) throws QueryException {
        return this.value(ctx).iter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value value(QueryContext ctx) throws QueryException {
        if (this.value == null) {
            if (this.expr == null) {
                Err.VAREMPTY.thrw(this.info, this);
            }
            Value v = ctx.value;
            ctx.value = null;
            try {
                this.value = this.cast(ctx.value(this.expr.compile(ctx)), ctx);
            }
            finally {
                ctx.value = v;
            }
        }
        return this.value;
    }

    public boolean is(Var v) {
        return this.id == v.id;
    }

    private Value cast(Value v, QueryContext ctx) throws QueryException {
        return this.type == null ? v : this.type.promote(v, ctx, this.info);
    }

    @Override
    public Var copy() {
        Var v = new Var(this.info, this.name, this.type, this.id, this.ann);
        v.global = this.global;
        v.value = this.value;
        v.expr = this.expr;
        v.type = this.type;
        v.ret = this.ret;
        return v;
    }

    @Override
    public boolean uses(Expr.Use u) {
        return u == Expr.Use.VAR;
    }

    @Override
    public int count(Var v) {
        return this.is(v) ? 1 : 0;
    }

    @Override
    public boolean removable(Var v) {
        return false;
    }

    @Override
    public Var remove(Var v) {
        return this;
    }

    @Override
    public boolean databases(StringList db) {
        return true;
    }

    @Override
    public SeqType type() {
        return this.ret != null ? this.ret : (this.type != null ? this.type : (this.expr != null ? this.expr.type() : SeqType.ITEM_ZM));
    }

    @Override
    public boolean sameAs(Expr cmp) {
        if (!(cmp instanceof Var)) {
            return false;
        }
        Var v = (Var)cmp;
        return this.name.eq(v.name) && this.type().eq(v.type());
    }

    @Override
    public void plan(FElem plan) {
        this.addPlan(plan, this.planElem(QueryText.NAM, this, QueryText.ID, this.id), this.expr);
    }

    @Override
    public String toString() {
        TokenBuilder tb = new TokenBuilder();
        if (this.name != null) {
            tb.add("$").add(this.name.string());
            if (this.type != null) {
                tb.add(" as");
            }
        }
        if (this.type != null) {
            tb.add(" " + this.type);
        }
        return tb.toString();
    }
}

