/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util;

import java.util.Arrays;
import org.basex.core.Text;
import org.basex.data.ExprInfo;
import org.basex.query.QueryException;
import org.basex.query.util.Var;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.FElem;
import org.basex.util.Array;

public final class VarStack
extends ExprInfo {
    public Var[] vars;
    public int size;

    public VarStack() {
        this(4);
    }

    public VarStack(int c) {
        this.vars = new Var[c];
    }

    public void update(Var v) {
        int i = this.indexOf(v);
        if (i == -1) {
            this.add(v);
        } else {
            this.vars[i] = v;
        }
    }

    public void add(Var v) {
        if (this.size == this.vars.length) {
            this.vars = Arrays.copyOf(this.vars, Array.newSize(this.size));
        }
        this.vars[this.size++] = v;
    }

    public Var get(QNm name) {
        int i = this.size;
        while (i-- > 0) {
            if (!name.eq(this.vars[i].name)) continue;
            return this.vars[i];
        }
        return null;
    }

    public Var get(Var v) {
        int i = this.indexOf(v);
        return i == -1 ? null : this.vars[i];
    }

    private int indexOf(Var v) {
        for (int s = this.size - 1; s >= 0; --s) {
            if (!v.is(this.vars[s])) continue;
            return s;
        }
        return -1;
    }

    public boolean contains(Var v) {
        return this.indexOf(v) != -1;
    }

    public void checkUp() throws QueryException {
        for (int i = 0; i < this.size; ++i) {
            this.vars[i].checkUp();
        }
    }

    @Override
    public void plan(FElem plan) {
        if (this.size == 0) {
            return;
        }
        FElem e = this.planElem(new Object[0]);
        for (int i = 0; i < this.size; ++i) {
            this.vars[i].plan(e);
        }
        this.addPlan(plan, e, new ExprInfo[0]);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.size; ++i) {
            sb.append((i == 0 ? "" : Text.NL) + i + ": " + this.vars[i]);
        }
        return sb.toString();
    }
}

