/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.seq;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.util.Err;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.Seq;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.util.InputInfo;

public final class ItemSeq
extends Seq {
    private final Item[] item;
    private Type ret;

    ItemSeq(Item[] it, int s) {
        super(s);
        this.item = it;
    }

    ItemSeq(Item[] it, int s, Type t) {
        this(it, s);
        this.ret = t;
    }

    @Override
    public Item ebv(QueryContext ctx, InputInfo ii) throws QueryException {
        if (!this.item[0].type.isNode()) {
            Err.CONDTYPE.thrw(ii, this);
        }
        return this.item[0];
    }

    @Override
    public SeqType type() {
        if (this.ret == null) {
            Type t = this.item[0].type;
            int s = 1;
            while ((long)s < this.size && t != AtomType.ITEM) {
                if (t != this.item[s].type) {
                    t = AtomType.ITEM;
                }
                ++s;
            }
            this.ret = t;
        }
        return SeqType.get(this.ret, SeqType.Occ.ONE_MORE);
    }

    @Override
    public boolean iterable() {
        return false;
    }

    @Override
    public boolean sameAs(Expr cmp) {
        if (!(cmp instanceof ItemSeq)) {
            return false;
        }
        ItemSeq is = (ItemSeq)cmp;
        return this.item == is.item && this.size == is.size;
    }

    @Override
    public int writeTo(Item[] arr, int start) {
        System.arraycopy(this.item, 0, arr, start, (int)this.size);
        return (int)this.size;
    }

    @Override
    public Item itemAt(long pos) {
        return this.item[(int)pos];
    }

    @Override
    public Value materialize(InputInfo ii) throws QueryException {
        int i = 0;
        while ((long)i < this.size) {
            this.item[i] = this.item[i].materialize(ii);
            ++i;
        }
        return this;
    }

    @Override
    public boolean homogenous() {
        return this.ret != null && this.ret != AtomType.ITEM;
    }
}

