/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util.list;

import java.util.Arrays;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.hash.TokenIntMap;
import org.basex.util.list.TokenList;

public class TwoWayTokenMap
extends TokenList {
    private final TokenIntMap map = new TokenIntMap();

    @Override
    public void add(byte[] e) {
        if (-1 != this.map.value(e)) {
            throw new IllegalArgumentException("Cannot insert value twice!");
        }
        super.add(e);
        this.map.add(e, this.size);
    }

    @Override
    public void add(long e) {
        this.add(Token.token(e));
    }

    @Override
    public void add(String e) {
        this.add(Token.token(e));
    }

    @Override
    public void set(int i, byte[] e) {
        if (-1 != this.map.value(e) && !Arrays.equals(this.get(i), e)) {
            throw new IllegalArgumentException("Cannot insert value twice!");
        }
        this.map.delete(this.get(i));
        super.set(i, e);
        this.map.add(e, i + 1);
    }

    public void set(int i, String e) {
        this.set(i, Token.token(e));
    }

    @Override
    public byte[] pop() {
        byte[] e = super.pop();
        this.map.delete(e);
        return e;
    }

    @Override
    public void push(byte[] val) {
        this.add(val);
    }

    @Override
    public boolean contains(byte[] e) {
        return this.map.value(e) != -1;
    }

    public boolean contains(String e) {
        return this.contains(Token.token(e));
    }

    @Override
    public TokenList sort(boolean cs) {
        throw Util.notimplemented(new Object[0]);
    }

    public int getKey(byte[] val) {
        int key = this.map.value(val);
        return key > 0 ? key - 1 : -1;
    }

    public int getKey(String val) {
        return this.getKey(Token.token(val));
    }

    public int delete(byte[] val) {
        int key = this.map.value(val);
        int n = key = key > 0 ? key - 1 : -1;
        if (-1 != key) {
            this.map.delete(val);
            this.list[key] = null;
        }
        return key;
    }

    public final int delete(String val) {
        return this.delete(Token.token(val));
    }
}

