/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.util.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.ClosedByInterruptException;
import java.util.Date;
import java.util.Hashtable;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import nl.mpi.util.Base64;
import nl.mpi.util.OurURL;
import nl.mpi.util.gui.MyAuthenticator;

public class AuthenticatedHttpConnection {
    private URLConnection connection = null;
    private static JFrame sParentF;
    private JFrame parentF;
    private JDialog parentD;
    private static JDialog sParentD;
    private String host = "";
    private String realm = "";
    private String currentKeystr = "";
    private String currentAuthstr = "";
    private String username = "";
    private String password = "";
    private static Hashtable userpasswpairs;
    private static Hashtable users;
    private static Hashtable passwords;
    static Authenticator authenticator;
    private boolean connected = false;
    private boolean gotResponse = false;
    private boolean forceAuthentication = false;
    private boolean promptUser = true;
    private boolean waitingForAuthorization = false;
    private boolean connectionCanceled = false;
    private int responseCode = -1;
    private IOException encounteredException;
    private boolean errorOccured = false;
    static int OK;
    static int IGNORE;
    static int CANCEL;
    static int INLIST;

    public AuthenticatedHttpConnection(String url, JDialog parent, boolean forceAuthentication, boolean promptUser) throws MalformedURLException, IOException {
        this.connection = new OurURL(url).openConnection();
        this.parentD = parent;
        this.forceAuthentication = forceAuthentication;
        this.promptUser = promptUser;
    }

    public AuthenticatedHttpConnection(String url, boolean forceAuthentication, boolean promptUser) throws MalformedURLException, IOException {
        this.connection = new OurURL(url).openConnection();
        this.forceAuthentication = forceAuthentication;
        this.promptUser = promptUser;
    }

    public AuthenticatedHttpConnection(String url, JFrame parent, boolean forceAuthentication, boolean promptUser) throws MalformedURLException, IOException {
        this.connection = new OurURL(url).openConnection();
        this.parentF = parent;
        this.forceAuthentication = forceAuthentication;
        this.promptUser = promptUser;
    }

    public AuthenticatedHttpConnection(OurURL url, JDialog parent, boolean forceAuthentication, boolean promptUser) throws MalformedURLException, IOException {
        this.connection = url.openConnection();
        this.parentD = parent;
        this.forceAuthentication = forceAuthentication;
        this.promptUser = promptUser;
    }

    public AuthenticatedHttpConnection(URL url, JDialog parent, boolean forceAuthentication, boolean promptUser) throws MalformedURLException, IOException {
        this.connection = url.openConnection();
        this.parentD = parent;
        this.forceAuthentication = forceAuthentication;
        this.promptUser = promptUser;
    }

    public AuthenticatedHttpConnection(OurURL url, JFrame parent, boolean forceAuthentication, boolean promptUser) throws IOException {
        this.connection = url.openConnection();
        this.parentF = parent;
        this.forceAuthentication = forceAuthentication;
        this.promptUser = promptUser;
    }

    public AuthenticatedHttpConnection(OurURL url, boolean forceAuthentication, boolean promptUser) throws IOException {
        this.connection = url.openConnection();
        this.forceAuthentication = forceAuthentication;
        this.promptUser = promptUser;
    }

    public AuthenticatedHttpConnection(URL url, JFrame parent, boolean forceAuthentication, boolean promptUser) throws IOException {
        this.connection = url.openConnection();
        this.parentF = parent;
        this.forceAuthentication = forceAuthentication;
        this.promptUser = promptUser;
    }

    public AuthenticatedHttpConnection(URL url, boolean forceAuthentication, boolean promptUser) throws IOException {
        this.connection = url.openConnection();
        this.forceAuthentication = forceAuthentication;
        this.promptUser = promptUser;
    }

    public AuthenticatedHttpConnection(HttpURLConnection connection, JDialog parent, boolean forceAuthentication, boolean promptUser) {
        this.connection = connection;
        this.parentD = parent;
        this.forceAuthentication = forceAuthentication;
        this.promptUser = promptUser;
    }

    public AuthenticatedHttpConnection(HttpURLConnection connection, JFrame parent, boolean forceAuthentication, boolean promptUser) {
        this.connection = connection;
        this.parentF = parent;
        this.forceAuthentication = forceAuthentication;
        this.promptUser = promptUser;
    }

    public AuthenticatedHttpConnection(HttpURLConnection connection, boolean forceAuthentication, boolean promptUser) {
        this.connection = connection;
        this.forceAuthentication = forceAuthentication;
        this.promptUser = promptUser;
    }

    public static void setDefaultAuthenticator() {
        Authenticator.setDefault(authenticator);
    }

    public static void setDialog(JDialog dialog) {
        sParentD = dialog;
    }

    public static void setFrame(JFrame frame) {
        sParentF = frame;
    }

    public void connect() throws IOException {
        int userResponse = -1;
        this.connected = false;
        boolean auto = false;
        boolean authorizationRequired = false;
        while (!(this.connectionCanceled || this.connected || this.responseCode != -1 && this.responseCode != 401 || this.errorOccured)) {
            this.connectDirect();
            if (this.responseCode != 401) continue;
            authorizationRequired = true;
            userResponse = this.handleAuthorizationRequired();
            if (userResponse == IGNORE) {
                AuthenticatedHttpConnection.storeAuthentication(this.host, this.realm, "");
                break;
            }
            if (userResponse == CANCEL) break;
            if (userResponse == INLIST) {
                this.connection = ((HttpURLConnection)this.connection).getURL().openConnection();
                this.currentAuthstr = AuthenticatedHttpConnection.getAuthentication(this.host, this.realm);
                this.connection.setRequestProperty("Authorization", this.currentAuthstr);
                continue;
            }
            if (userResponse == OK) {
                try {
                    ((HttpURLConnection)this.connection).disconnect();
                    this.currentAuthstr = AuthenticatedHttpConnection.makeAuthentication(this.username, this.password);
                    this.connection = ((HttpURLConnection)this.connection).getURL().openConnection();
                    this.connection.setRequestProperty("Authorization", this.currentAuthstr);
                }
                catch (IOException ioe) {
                    System.err.println("AuthenticatedHttpConnection:handleAuthorizationRequired(): " + this.connection.getURL() + ", " + ioe);
                }
                continue;
            }
            ((HttpURLConnection)this.connection).disconnect();
            break;
        }
        if (this.connected && authorizationRequired) {
            AuthenticatedHttpConnection.storeAuthentication(this.host, this.realm, this.currentAuthstr);
        }
        if (this.errorOccured && this.encounteredException != null) {
            throw this.encounteredException;
        }
    }

    public void connectInThread() throws IOException {
        int maxwaitduration = 5000;
        int waitduration = 100;
        int twaited = 0;
        this.gotResponse = false;
        Thread connectThread = new Thread(new Runnable(){

            public void run() {
                try {
                    AuthenticatedHttpConnection.this.connectDirect();
                }
                catch (IOException ioe) {
                    System.out.println("AuthenticatedHttpConnection; IOEXception for: " + AuthenticatedHttpConnection.this.connection.getURL() + " " + ioe);
                    AuthenticatedHttpConnection.this.encounteredException = ioe;
                }
            }
        });
        Date date = new Date();
        connectThread.start();
        boolean waited = false;
        try {
            while (!this.gotResponse && twaited < maxwaitduration) {
                Thread.currentThread();
                Thread.sleep(waitduration);
                waitduration = 2 * waitduration;
                System.out.println("in wait loop: twaited=" + (twaited += waitduration) + " , isAlive=" + connectThread.isAlive());
            }
        }
        catch (Exception e) {
            System.err.println("connectInThread() " + e);
        }
        if (!this.gotResponse) {
            System.out.println("AuthenticatedHttpConnection: still no response from " + this.connection.getURL() + " , now breaking off");
            this.connectionCanceled = true;
            this.connected = false;
            connectThread.interrupt();
            throw new IOException("Timedout wait");
        }
        if (this.encounteredException != null) {
            throw this.encounteredException;
        }
    }

    private void connectDirect() throws IOException {
        this.gotResponse = false;
        this.responseCode = -1;
        try {
            this.connection.connect();
            if (this.connectionCanceled) {
                return;
            }
            if (!(this.connection instanceof HttpURLConnection)) {
                this.responseCode = 200;
                return;
            }
            this.responseCode = ((HttpURLConnection)this.connection).getResponseCode();
            if (this.responseCode == 200) {
                this.gotResponse = true;
                this.connected = true;
            } else if (this.responseCode == 401) {
                this.connected = false;
                this.gotResponse = true;
            } else {
                this.gotResponse = true;
                this.connected = false;
            }
            return;
        }
        catch (ClosedByInterruptException ie) {
            System.err.println("AuthenticatedHttpConnection: error connect call to " + this.connection.getURL() + " had to be interrupted");
            this.errorOccured = true;
        }
        catch (IOException ioe) {
            System.err.println("AuthenticatedHttpConnection: error connect call to " + this.connection.getURL() + " IOException: " + ioe);
            this.encounteredException = ioe;
            this.errorOccured = true;
        }
        catch (NullPointerException npe) {
            System.err.println("AuthenticatedHttpConnection: bug in HttpURLConnect.connect() call: ignoring it");
        }
        catch (Exception e) {
            System.err.println("AuthenticatedHttpConnection: Ignoring Unexpected exception for " + this.connection.getURL() + " " + e.getMessage());
            this.errorOccured = true;
        }
        this.connected = false;
    }

    public void disconnect() {
        if (this.connection instanceof HttpURLConnection) {
            ((HttpURLConnection)this.connection).disconnect();
        }
        this.connected = false;
    }

    public URL getURL() {
        return this.connection.getURL();
    }

    public URLConnection getURLConnection() {
        return this.connection;
    }

    public int getContentLength() {
        return this.connection.getContentLength();
    }

    public long getLastModified() {
        return this.connection.getLastModified();
    }

    public InputStream getInputStream() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        return this.connection.getInputStream();
    }

    public OutputStream getOutputStream() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        return this.connection.getOutputStream();
    }

    private void decodeHeader() {
        this.realm = "";
        this.host = "" + this.connection.getURL().getHost();
        int n = 0;
        while (this.connection.getHeaderField(n) != null) {
            int ie;
            String rs;
            int is;
            if (this.connection.getHeaderField(n).indexOf("realm") >= 0 && (is = (rs = this.connection.getHeaderField(n)).indexOf("\"")) >= 0 && (ie = rs.indexOf("\"", is + 1)) >= 0) {
                this.realm = rs.substring(is + 1, ie);
            }
            ++n;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int handleAuthorizationRequired() {
        this.decodeHeader();
        boolean inlist = false;
        int answer = -1;
        this.currentAuthstr = AuthenticatedHttpConnection.getAuthentication(this.host, this.realm);
        if (this.currentAuthstr != null) {
            inlist = true;
            if (!this.currentAuthstr.equals("")) return INLIST;
            if (!this.forceAuthentication) return IGNORE;
            this.waitingForAuthorization = true;
            answer = this.showAuthorizationDialog(this.host, this.realm);
        } else if (this.promptUser) {
            this.waitingForAuthorization = true;
            answer = this.showAuthorizationDialog(this.host, this.realm);
        } else if (!this.promptUser) {
            this.connected = false;
            return -1;
        }
        if (answer == CANCEL) {
            this.currentKeystr = "";
            return CANCEL;
        }
        if (answer == IGNORE) {
            this.currentAuthstr = "";
            return IGNORE;
        }
        if (answer == OK) {
            return OK;
        }
        if (!inlist) return answer;
        return INLIST;
    }

    private int showAuthorizationDialog(String host, String realm) {
        AuthorizationDialog ad = null;
        if (this.parentF != null) {
            ad = new AuthorizationDialog(this.parentF, host, realm);
        } else if (this.parentD != null) {
            ad = new AuthorizationDialog(this.parentD, host, realm);
        } else if (sParentF != null) {
            ad = new AuthorizationDialog(sParentF, host, realm);
        } else if (sParentD != null) {
            ad = new AuthorizationDialog(sParentD, host, realm);
        } else if (ad == null) {
            ad = new AuthorizationDialog(new JFrame(), host, realm);
        }
        ad.setVisible(true);
        if (ad.getResponse() == IGNORE) {
            this.currentAuthstr = "";
        } else if (ad.getResponse() == OK) {
            this.username = ad.getUserName();
            this.password = ad.getPassword();
            this.currentAuthstr = "Basic " + Base64.encodeString(this.username + ":" + this.password);
        }
        return ad.getResponse();
    }

    public String getAuthorizationString() {
        return this.currentAuthstr;
    }

    public static void clearPasswords() {
        userpasswpairs = new Hashtable();
        users = new Hashtable();
        passwords = new Hashtable();
    }

    static String makeAuthentication(String username, String passwd) {
        String authstr = "Basic " + Base64.encodeString(username + ":" + passwd);
        return authstr;
    }

    static void storeAuthentication(String host, String realm, String authstring) {
        String keystr = host + ":" + realm;
        userpasswpairs.put(keystr, authstring);
    }

    static String getAuthentication(String host, String realm) {
        String keystr = host + ":" + realm;
        if (userpasswpairs.containsKey(keystr)) {
            return (String)userpasswpairs.get(keystr);
        }
        return null;
    }

    static {
        userpasswpairs = new Hashtable();
        users = new Hashtable();
        passwords = new Hashtable();
        authenticator = new MyAuthenticator(userpasswpairs, users, passwords);
        AuthenticatedHttpConnection.setDefaultAuthenticator();
        Properties props = System.getProperties();
        props.setProperty("sun.net.client.defaultConnectTimeout", "5000");
        props.setProperty("sun.net.client.defaultReadTimeout", "12000");
        OK = 1;
        IGNORE = 2;
        CANCEL = 3;
        INLIST = 4;
    }

    private class AuthorizationDialog
    extends JDialog
    implements ActionListener {
        private JPasswordField passwordField;
        private JTextField userField;
        private int answer;
        private String host;
        private String realm;

        AuthorizationDialog(JFrame owner, String host, String realm) {
            super(owner, "Authorization Required", true);
            this.answer = -1;
            this.host = host;
            this.realm = realm;
            this.init();
            this.setLocationRelativeTo(owner);
        }

        AuthorizationDialog(JDialog owner, String host, String realm) {
            super(owner, "Authorization Required", true);
            this.answer = -1;
            this.host = host;
            this.realm = realm;
            this.init();
            this.setLocationRelativeTo(owner);
        }

        private void init() {
            this.userField = new JTextField(20);
            this.passwordField = new JPasswordField(20);
            JPanel cpane = new JPanel(new GridLayout(0, 1, 6, 6));
            cpane.add(new JLabel("Authentication needed for:"));
            cpane.add(new JLabel("Host: " + this.host));
            cpane.add(new JLabel("Realm: " + this.realm));
            cpane.add(new JLabel("User name:"));
            cpane.add(this.userField);
            cpane.add(new JLabel("Password:"));
            cpane.add(this.passwordField);
            cpane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            JPanel butP = new JPanel(new FlowLayout(2, 6, 6));
            JButton igB = new JButton("Ignore");
            igB.addActionListener(this);
            igB.setActionCommand("IGNORE");
            butP.add(igB);
            JButton okB = new JButton("OK");
            okB.addActionListener(this);
            okB.setActionCommand("OK");
            butP.add(okB);
            this.getRootPane().setDefaultButton(okB);
            JButton cancelB = new JButton("Cancel");
            cancelB.addActionListener(this);
            cancelB.setActionCommand("CANCEL");
            butP.add(cancelB);
            Container cont = this.getContentPane();
            cont.setLayout(new BorderLayout(6, 6));
            cont.add((Component)cpane, "Center");
            cont.add((Component)butP, "South");
            if (AuthenticatedHttpConnection.this.forceAuthentication) {
                igB.setEnabled(false);
            }
            this.pack();
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getActionCommand().equals("OK")) {
                this.answer = OK;
            } else if (e.getActionCommand().equals("CANCEL")) {
                this.answer = CANCEL;
            } else if (e.getActionCommand().equals("IGNORE")) {
                this.answer = IGNORE;
            } else {
                System.err.println("--- Unexpected action event: " + e);
            }
            this.setVisible(false);
        }

        int getResponse() {
            return this.answer;
        }

        String getUserName() {
            return this.userField.getText();
        }

        String getPassword() {
            return new String(this.passwordField.getPassword());
        }
    }
}

