/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.kintypestrings;

import java.util.ArrayList;
import nl.mpi.kinnate.kintypestrings.KinTypeElement;
import nl.mpi.kinnate.kintypestrings.KinTypeStringConverter;
import nl.mpi.kinnate.kintypestrings.ParserHighlight;
import nl.mpi.kinnate.kintypestrings.QueryTerm;

public class QuerySectionParser {
    String consumableString;
    ParserHighlight parserHighlight;
    boolean foundKinType;
    String errorMessage;

    public QuerySectionParser(String consumableString, ParserHighlight parserHighlight, boolean foundKinType, String errorMessage) {
        this.consumableString = consumableString;
        this.parserHighlight = parserHighlight;
        this.foundKinType = foundKinType;
        this.errorMessage = errorMessage;
    }

    protected String parseQuerySection(KinTypeElement currentElement, int initialLength) {
        if (this.consumableString.startsWith("[")) {
            int highlightPosition = initialLength - this.consumableString.length();
            String highlightMessage = "Query: ";
            while (this.consumableString.startsWith("[")) {
                int queryStart = "[".length();
                int queryEnd = this.consumableString.indexOf("]");
                if (queryEnd == -1) {
                    this.errorMessage = highlightMessage = highlightMessage + "No closing bracket ']' found";
                    this.foundKinType = false;
                    break;
                }
                if (queryEnd - queryStart < 3) {
                    this.errorMessage = highlightMessage = highlightMessage + "Query must be over 2 chars long";
                    this.foundKinType = false;
                    break;
                }
                if (currentElement.queryTerms == null) {
                    currentElement.queryTerms = new ArrayList();
                }
                String queryText = this.consumableString.substring(queryStart, queryEnd);
                this.consumableString = this.consumableString.substring(queryEnd + 1);
                KinTypeStringConverter.QueryType currentQueryType = null;
                String[] queryTerm = queryText.split("==");
                if (queryTerm.length > 1) {
                    currentQueryType = KinTypeStringConverter.QueryType.Equals;
                } else {
                    queryTerm = queryText.split("=");
                    if (queryTerm.length > 1) {
                        currentQueryType = KinTypeStringConverter.QueryType.Contains;
                    } else {
                        queryTerm = queryText.split("\\>");
                        if (queryTerm.length > 1) {
                            currentQueryType = KinTypeStringConverter.QueryType.Greater;
                        } else {
                            queryTerm = queryText.split("\\<");
                            if (queryTerm.length > 1) {
                                currentQueryType = KinTypeStringConverter.QueryType.Less;
                            }
                        }
                    }
                }
                if (currentQueryType == null) {
                    currentElement.queryTerms.add(new QueryTerm("*", KinTypeStringConverter.QueryType.Contains, queryText));
                    highlightMessage = highlightMessage + "Any field containing '" + queryText + "'";
                    continue;
                }
                if (queryTerm[0].length() <= 0 || queryTerm[1].length() <= 0) continue;
                currentElement.queryTerms.add(new QueryTerm("*:" + queryTerm[0].replaceAll("\\.", "/*:"), currentQueryType, queryTerm[1]));
                highlightMessage = highlightMessage + "Only the field '" + queryTerm[0] + "' containing '" + queryTerm[1] + "'";
            }
            this.parserHighlight = this.parserHighlight.addHighlight(ParserHighlight.ParserHighlightType.Query, highlightPosition, highlightMessage);
        }
        return this.consumableString;
    }
}

