/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.projects;

import java.io.File;
import java.util.Calendar;
import java.util.Date;
import java.util.UUID;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="ProjectRecord")
public class ProjectRecord {
    protected File projectDirectory;
    protected String projectName;
    protected String projectDescription;
    protected String projectUUID;
    protected int entityCount;
    protected int relationCount;
    protected Date lastChangeDate;

    public ProjectRecord() {
    }

    public ProjectRecord(File projectDirectory, String projectName) {
        this.projectName = projectName;
        this.projectDirectory = projectDirectory;
        this.projectUUID = UUID.randomUUID().toString();
        this.lastChangeDate = Calendar.getInstance().getTime();
    }

    @Deprecated
    public ProjectRecord(File projectDirectory, String projectName, String projectUUID) {
        this.projectName = projectName;
        this.projectDirectory = projectDirectory;
        this.projectUUID = projectUUID;
        this.lastChangeDate = Calendar.getInstance().getTime();
    }

    public File getProjectDirectory() {
        return this.projectDirectory;
    }

    @XmlElement(name="ProjectDirectory")
    public void setProjectDirectory(File projectDirectory) {
        this.projectDirectory = projectDirectory;
    }

    public void bumpLastChangeDate() {
        this.lastChangeDate = Calendar.getInstance().getTime();
    }

    public String getProjectName() {
        return this.projectName;
    }

    @XmlAttribute(name="ProjectName")
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getProjectDescription() {
        return this.projectDescription;
    }

    @XmlElement(name="ProjectDescription")
    public void setProjectDescription(String projectDescription) {
        this.projectDescription = projectDescription;
    }

    public int getEntityCount() {
        return this.entityCount;
    }

    @XmlAttribute(name="EntityCount")
    public void setEntityCount(int entityCount) {
        this.entityCount = entityCount;
    }

    public int getRelationCount() {
        return this.relationCount;
    }

    @XmlAttribute(name="RelationCount")
    public void setRelationCount(int relationCount) {
        this.relationCount = relationCount;
    }

    public Date getLastChangeDate() {
        return this.lastChangeDate;
    }

    @XmlElement(name="LastChangeTime")
    public void setLastChangeDate(Date lastChangeDate) {
        this.lastChangeDate = lastChangeDate;
    }

    public File getProjectDataFilesDirectory() {
        return this.createDirectoryIfNotFound(new File(this.getProjectDirectory(), "KinDataFiles"));
    }

    public String getProjectUUID() {
        return this.projectUUID;
    }

    @XmlAttribute(name="ProjectUUID")
    public void setProjectUUID(String projectUUID) {
        this.projectUUID = projectUUID;
    }

    private File createDirectoryIfNotFound(File directoryFile) {
        if (!directoryFile.exists()) {
            directoryFile.mkdir();
        }
        return directoryFile;
    }

    public int hashCode() {
        int hash = 5;
        hash = 73 * hash + (this.projectDirectory != null ? this.projectDirectory.hashCode() : 0);
        hash = 73 * hash + (this.projectUUID != null ? this.projectUUID.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProjectRecord other = (ProjectRecord)obj;
        if (!(this.projectDirectory == other.projectDirectory || this.projectDirectory != null && this.projectDirectory.equals(other.projectDirectory))) {
            return false;
        }
        return !(this.projectUUID == null ? other.projectUUID != null : !this.projectUUID.equals(other.projectUUID));
    }
}

