/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.svg;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import nl.mpi.arbil.util.BugCatcherManager;
import nl.mpi.kinnate.entityindexer.IndexerParameters;
import nl.mpi.kinnate.kindata.DataTypes;
import nl.mpi.kinnate.kindata.GraphSorter;
import nl.mpi.kinnate.kindata.RelationTypeDefinition;
import nl.mpi.kinnate.kindata.VisiblePanelSetting;
import nl.mpi.kinnate.kintypestrings.KinTermGroup;
import nl.mpi.kinnate.kintypestrings.KinType;
import nl.mpi.kinnate.projects.ProjectRecord;
import nl.mpi.kinnate.ui.entityprofiles.ProfileRecord;
import nl.mpi.kinnate.uniqueidentifiers.UniqueIdentifier;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.svg.SVGDocument;

@XmlRootElement(name="KinDiagramData", namespace="http://mpi.nl/tla/kin")
public class DataStoreSvg {
    protected static String kinDataNameSpace = "kin";
    protected static String kinDataNameSpaceLocation = "http://mpi.nl/tla/kin";
    @XmlElement(name="EgoId", namespace="http://mpi.nl/tla/kin")
    public HashSet<UniqueIdentifier> egoEntities = new HashSet();
    @XmlElement(name="RequiredEntities", namespace="http://mpi.nl/tla/kin")
    public HashSet<UniqueIdentifier> requiredEntities = new HashSet();
    @XmlElementWrapper(name="RelationTypeDefinitions")
    @XmlElement(name="RelationType", namespace="http://mpi.nl/tla/kin")
    private RelationTypeDefinition[] relationTypeDefinitions = null;
    @XmlElementWrapper(name="KinTypeDefinitions")
    @XmlElement(name="KinType", namespace="http://mpi.nl/tla/kin")
    protected KinType[] kinTypeDefinitions = null;
    @XmlElement(name="KinTypeString", namespace="http://mpi.nl/tla/kin")
    protected String[] kinTypeStrings = new String[0];
    @XmlElement(name="IndexParameters", namespace="http://mpi.nl/tla/kin")
    protected IndexerParameters indexParameters;
    @XmlElement(name="KinTermGroup", namespace="http://mpi.nl/tla/kin")
    protected KinTermGroup[] kinTermGroups = new KinTermGroup[0];
    @XmlElement(name="ProjectRecord", namespace="http://mpi.nl/tla/kin")
    public ProjectRecord projectRecord = null;
    @XmlElementWrapper(name="SelectedProfiles")
    @XmlElement(name="Profile", namespace="http://mpi.nl/tla/kin")
    public ProfileRecord[] selectedProfiles = ProfileRecord.getDefaultProfiles();
    @XmlElement(name="ShowLabels", namespace="http://mpi.nl/tla/kin")
    public boolean showLabels = true;
    @XmlElement(name="ShowKinTypeLabels", namespace="http://mpi.nl/tla/kin")
    public boolean showKinTypeLabels = false;
    @XmlElement(name="ShowIdLabels", namespace="http://mpi.nl/tla/kin")
    public boolean showIdLabels = false;
    @XmlElement(name="ShowDateLabels", namespace="http://mpi.nl/tla/kin")
    public boolean showDateLabels = false;
    @XmlElement(name="ShowKinTermLines", namespace="http://mpi.nl/tla/kin")
    public boolean showKinTermLines = true;
    @XmlElement(name="SnapToGrid", namespace="http://mpi.nl/tla/kin")
    public boolean snapToGrid = true;
    @XmlElement(name="ShowSanguineLines", namespace="http://mpi.nl/tla/kin")
    public boolean showSanguineLines = true;
    @XmlElement(name="ShowExternalLinks", namespace="http://mpi.nl/tla/kin")
    public boolean showExternalLinks = true;
    @XmlElement(name="HighlightRelationLines", namespace="http://mpi.nl/tla/kin")
    public boolean highlightRelationLines = true;
    @XmlElement(name="ShowDiagramBorder", namespace="http://mpi.nl/tla/kin")
    public boolean showDiagramBorder = true;
    @XmlElement(name="DefaultSymbol", namespace="http://mpi.nl/tla/kin")
    public String defaultSymbol = "rhombus";
    @XmlTransient
    public GraphSorter graphData;
    @XmlElement(name="DiagramMode", namespace="http://mpi.nl/tla/kin")
    public DiagramMode diagramMode = DiagramMode.Undefined;
    @XmlElement(name="DiagramPanel", namespace="http://mpi.nl/tla/kin")
    private HashSet<VisiblePanelSetting> visiblePanels;

    public void setDefaults() {
        this.kinTermGroups = new KinTermGroup[0];
        this.indexParameters = new IndexerParameters();
    }

    @XmlTransient
    public RelationTypeDefinition[] getRelationTypeDefinitions() {
        if (this.relationTypeDefinitions != null) {
            return this.relationTypeDefinitions;
        }
        return new DataTypes().getReferenceRelations();
    }

    public void setRelationTypeDefinitions(RelationTypeDefinition[] relationTypeDefinitions) {
        this.relationTypeDefinitions = relationTypeDefinitions;
    }

    public void addRelationTypeDefinition(RelationTypeDefinition relationTypeDefinitionToAdd) {
        HashMap<RelationTypeHashKey, RelationTypeDefinition> kinTypesList = new HashMap<RelationTypeHashKey, RelationTypeDefinition>();
        kinTypesList.put(new RelationTypeHashKey(relationTypeDefinitionToAdd.getDisplayName(), relationTypeDefinitionToAdd.getDataCategory()), relationTypeDefinitionToAdd);
        for (RelationTypeDefinition relationTypeDefinition : Arrays.asList(this.getRelationTypeDefinitions())) {
            RelationTypeHashKey relationTypeHashKey = new RelationTypeHashKey(relationTypeDefinition.getDisplayName(), relationTypeDefinition.getDataCategory());
            RelationTypeDefinition foundType = (RelationTypeDefinition)kinTypesList.get(relationTypeHashKey);
            if (foundType == null) {
                kinTypesList.put(relationTypeHashKey, relationTypeDefinition);
                continue;
            }
            HashSet<DataTypes.RelationType> relationTypes = new HashSet<DataTypes.RelationType>(Arrays.asList(foundType.getRelationType()));
            relationTypes.addAll(Arrays.asList(relationTypeDefinition.getRelationType()));
            kinTypesList.put(relationTypeHashKey, new RelationTypeDefinition(relationTypeDefinition.getDisplayName(), relationTypeDefinition.getDataCategory(), relationTypes.toArray(new DataTypes.RelationType[0]), relationTypeDefinition.getLineColour(), relationTypeDefinition.getLineWidth(), relationTypeDefinition.getLineDash(), relationTypeDefinition.getCurveLineOrientation()));
        }
        this.relationTypeDefinitions = kinTypesList.values().toArray(new RelationTypeDefinition[0]);
    }

    @XmlTransient
    public KinType[] getKinTypeDefinitions() {
        KinType[] returnArray = this.kinTypeDefinitions != null ? this.kinTypeDefinitions : KinType.getReferenceKinTypes();
        Collections.sort(Arrays.asList(returnArray));
        return returnArray;
    }

    public void setKinTypeDefinitions(KinType[] kinTypeDefinitions) {
        this.kinTypeDefinitions = kinTypeDefinitions;
    }

    public VisiblePanelSetting[] getVisiblePanels() {
        if (this.visiblePanels == null) {
            return null;
        }
        return this.visiblePanels.toArray(new VisiblePanelSetting[0]);
    }

    public VisiblePanelSetting getPanelSettingByType(VisiblePanelSetting.PanelType panelType) {
        VisiblePanelSetting[] visiblePanelsArray = this.getVisiblePanels();
        if (visiblePanelsArray != null) {
            for (VisiblePanelSetting panelSetting : visiblePanelsArray) {
                if (panelSetting.getPanelType() == null || panelSetting.getPanelType() != panelType) continue;
                return panelSetting;
            }
        }
        return null;
    }

    public VisiblePanelSetting setPanelState(VisiblePanelSetting.PanelType panelType, int panelWidth, boolean panelVisible) {
        if (this.visiblePanels == null) {
            this.visiblePanels = new HashSet();
        }
        VisiblePanelSetting visiblePanelSetting = new VisiblePanelSetting(panelType, panelVisible, panelWidth);
        this.visiblePanels.add(visiblePanelSetting);
        return visiblePanelSetting;
    }

    protected void storeAllData(SVGDocument doc) {
        System.out.println("Removing old KinDiagramData nodes from the SVG before updating");
        NodeList dataNodes = doc.getElementsByTagNameNS("http://mpi.nl/tla/kin", "KinDiagramData");
        while (dataNodes.getLength() > 0) {
            dataNodes.item(0).getParentNode().removeChild(dataNodes.item(0));
        }
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{DataStoreSvg.class});
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.marshal((Object)this, (Node)doc.getRootElement());
        }
        catch (JAXBException exception) {
            BugCatcherManager.getBugCatcher().logError((Exception)((Object)exception));
        }
    }

    protected static DataStoreSvg loadDataFromSvg(SVGDocument doc) {
        DataStoreSvg dataStoreSvg = new DataStoreSvg();
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{DataStoreSvg.class});
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            NodeList dataStoreNodeList = doc.getElementsByTagNameNS("http://mpi.nl/tla/kin", "KinDiagramData");
            if (dataStoreNodeList.getLength() > 0) {
                dataStoreSvg = (DataStoreSvg)unmarshaller.unmarshal(dataStoreNodeList.item(0), DataStoreSvg.class).getValue();
            }
        }
        catch (JAXBException exception) {
            BugCatcherManager.getBugCatcher().logError((Exception)((Object)exception));
        }
        return dataStoreSvg;
    }

    class RelationTypeHashKey {
        String displayName;
        String dataCategory;

        public RelationTypeHashKey(String displayName, String dataCategory) {
            this.displayName = displayName;
            this.dataCategory = dataCategory;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RelationTypeHashKey other = (RelationTypeHashKey)obj;
            if (this.displayName == null ? other.displayName != null : !this.displayName.equals(other.displayName)) {
                return false;
            }
            return !(this.dataCategory == null ? other.dataCategory != null : !this.dataCategory.equals(other.dataCategory));
        }

        public int hashCode() {
            int hash = 5;
            hash = 53 * hash + (this.displayName != null ? this.displayName.hashCode() : 0);
            hash = 53 * hash + (this.dataCategory != null ? this.dataCategory.hashCode() : 0);
            return hash;
        }
    }

    public class GraphRelationData {
        public UniqueIdentifier egoNodeId;
        public UniqueIdentifier alterNodeId;
        public DataTypes.RelationType relationType;
        public RelationTypeDefinition.CurveLineOrientation curveLineOrientation;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DiagramMode {
        FreeForm,
        KinTypeQuery,
        Undefined;

    }
}

