/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.ui.kintypeeditor;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.table.TableCellEditor;
import nl.mpi.kinnate.ui.kintypeeditor.ArrayListCellRenderer;
import nl.mpi.kinnate.ui.kintypeeditor.CheckBoxModel;

public class CheckBoxRenderer
extends DefaultCellEditor
implements ListCellRenderer,
TableCellEditor,
ActionListener {
    private CheckBoxModel kinTypeTableModel;
    private JComboBox comboBoxRelationType;
    private ArrayList<String> selectedItems;
    private int row;
    private int column;

    public CheckBoxRenderer(CheckBoxModel kinTypeTableModel, JComboBox comboBoxRelationType) {
        super(comboBoxRelationType);
        this.kinTypeTableModel = kinTypeTableModel;
        this.comboBoxRelationType = comboBoxRelationType;
        comboBoxRelationType.addItem(ArrayListCellRenderer.anyOptionDisplayString);
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.selectedItems = value instanceof ArrayList ? (ArrayList)value : new ArrayList();
        this.row = row;
        this.column = column;
        return this.comboBoxRelationType;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        boolean checkBoxSelected = this.selectedItems == null ? ArrayListCellRenderer.anyOptionDisplayString.equals(value.toString()) : this.selectedItems.contains(value.toString());
        JCheckBox editorCheckBox = new JCheckBox(value.toString(), checkBoxSelected);
        editorCheckBox.addActionListener(this);
        return editorCheckBox;
    }

    public void actionPerformed(ActionEvent e) {
        String selectedItem = this.comboBoxRelationType.getSelectedItem().toString();
        if (ArrayListCellRenderer.anyOptionDisplayString.equals(selectedItem)) {
            if (this.selectedItems == null) {
                this.kinTypeTableModel.setListValueAt(new ArrayList<String>(), this.row, this.column);
            } else {
                this.kinTypeTableModel.setValueAt(null, this.row, this.column);
            }
        } else {
            if (this.selectedItems == null) {
                this.selectedItems = new ArrayList();
            }
            if (this.selectedItems.contains(selectedItem)) {
                this.selectedItems.remove(selectedItem);
            } else {
                this.selectedItems.add(selectedItem);
            }
            this.kinTypeTableModel.setListValueAt(this.selectedItems, this.row, this.column);
        }
    }
}

