/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.cmd;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.basex.core.Perm;
import org.basex.core.Text;
import org.basex.core.cmd.ACreate;
import org.basex.core.parse.CmdBuilder;
import org.basex.data.Data;
import org.basex.data.MetaData;
import org.basex.io.IO;
import org.basex.io.IOContent;
import org.basex.io.IOFile;
import org.basex.io.in.BufferInput;
import org.basex.io.out.PrintOutput;
import org.xml.sax.InputSource;

public final class Store
extends ACreate {
    public Store(String path) {
        this(path, (String)null);
    }

    public Store(String path, String input) {
        super(Perm.WRITE, true, path == null ? "" : path, input);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean run() {
        boolean create = this.context.user.has(Perm.CREATE);
        String path = MetaData.normPath(this.args[0]);
        if (path == null || path.endsWith(".")) {
            return this.error(Text.NAME_INVALID_X, this.args[0]);
        }
        if (this.in == null) {
            IO io = IO.get(this.args[1]);
            if (!io.exists() || io.isDir()) {
                return this.error(Text.RES_NOT_FOUND_X, create ? io : this.args[1]);
            }
            this.in = io.inputSource();
            if ((path.isEmpty() || path.endsWith("/")) && !(io instanceof IOContent)) {
                path = path + io.name();
            }
        }
        if (path.isEmpty()) {
            return this.error(Text.NAME_INVALID_X, path);
        }
        Data data = this.context.data();
        if (data.inMemory()) {
            return this.error(Text.NO_MAINMEM, new Object[0]);
        }
        IOFile file = data.meta.binary(path);
        if (path.isEmpty() || path.endsWith(".") || file == null || file.isDir()) {
            return this.error(Text.NAME_INVALID_X, create ? path : this.args[0]);
        }
        if (!data.startUpdate()) {
            return this.error(Text.DB_PINNED_X, data.meta.name);
        }
        try {
            Store.store(this.in, file);
            boolean bl = this.info(Text.QUERY_EXECUTED_X, this.perf);
            return bl;
        }
        catch (IOException ex) {
            boolean bl = this.error(Text.FILE_NOT_STORED_X, ex.getMessage());
            return bl;
        }
        finally {
            data.finishUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void store(InputSource in, IOFile file) throws IOException {
        block11: {
            new IOFile(file.dir()).md();
            PrintOutput po = new PrintOutput(file.path());
            try {
                Reader r = in.getCharacterStream();
                InputStream is = in.getByteStream();
                String id = in.getSystemId();
                if (r != null) {
                    int c;
                    while ((c = r.read()) != -1) {
                        po.utf8(c);
                    }
                    break block11;
                }
                if (is != null) {
                    int b;
                    while ((b = is.read()) != -1) {
                        po.write(b);
                    }
                    break block11;
                }
                if (id == null) break block11;
                BufferInput bi = new BufferInput(IO.get(id));
                try {
                    int b;
                    while ((b = bi.read()) != -1) {
                        po.write(b);
                    }
                }
                finally {
                    bi.close();
                }
            }
            finally {
                po.close();
            }
        }
    }

    @Override
    public void build(CmdBuilder cb) {
        cb.init().arg("TO", 0).arg(1);
    }
}

