/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.ft;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.CmpG;
import org.basex.query.expr.Context;
import org.basex.query.expr.Expr;
import org.basex.query.expr.ParseExpr;
import org.basex.query.ft.FTContainsIndex;
import org.basex.query.ft.FTExpr;
import org.basex.query.ft.FTIndexAccess;
import org.basex.query.iter.Iter;
import org.basex.query.path.AxisPath;
import org.basex.query.path.AxisStep;
import org.basex.query.util.IndexContext;
import org.basex.query.util.Var;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.DBNode;
import org.basex.query.value.node.FElem;
import org.basex.query.value.node.FTNode;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.SeqType;
import org.basex.util.InputInfo;
import org.basex.util.ft.FTLexer;
import org.basex.util.ft.FTOpt;
import org.basex.util.ft.Scoring;
import org.basex.util.list.StringList;

public class FTContains
extends ParseExpr {
    Expr expr;
    FTExpr ftexpr;
    FTLexer lex;

    public FTContains(Expr e, FTExpr fte, InputInfo ii) {
        super(ii);
        this.expr = e;
        this.ftexpr = fte;
        this.type = SeqType.BLN;
    }

    @Override
    public final void checkUp() throws QueryException {
        this.checkNoUp(this.expr);
    }

    @Override
    public final Expr compile(QueryContext ctx) throws QueryException {
        this.expr = this.expr.compile(ctx).addText(ctx);
        this.ftexpr = this.ftexpr.compile(ctx);
        if (this.lex == null) {
            this.lex = new FTLexer(new FTOpt());
        }
        return this.expr.isEmpty() ? this.optPre(Bln.FALSE, ctx) : this;
    }

    @Override
    public Bln item(QueryContext ctx, InputInfo ii) throws QueryException {
        Item it;
        Iter iter = this.expr.iter(ctx);
        FTLexer tmp = ctx.fttoken;
        double s = 0.0;
        ctx.fttoken = this.lex;
        while ((it = iter.next()) != null) {
            this.lex.init(it.string(this.info));
            FTNode item = this.ftexpr.item(ctx, this.info);
            double d = 0.0;
            if (item.all.matches() && (d = item.score()) == 0.0) {
                d = 1.0;
            }
            s = Scoring.and(s, d);
            if (!(d > 0.0) || ctx.ftpos == null || !(it instanceof DBNode)) continue;
            DBNode node = (DBNode)it;
            ctx.ftpos.add(node.data, node.pre, item.all);
        }
        ctx.fttoken = tmp;
        return Bln.get(s);
    }

    @Override
    public final boolean indexAccessible(IndexContext ic) throws QueryException {
        AxisStep s = this.expr instanceof Context ? ic.step : CmpG.indexStep(this.expr);
        boolean ok = s != null && ic.data.meta.ftxtindex && s.test.type == NodeType.TXT && this.ftexpr.indexAccessible(ic);
        ic.seq |= ic.not;
        return ok;
    }

    @Override
    public final Expr indexEquivalent(IndexContext ic) throws QueryException {
        ic.ctx.compInfo("applying full-text index", new Object[0]);
        FTExpr ie = this.ftexpr.indexEquivalent(ic);
        if (ic.seq) {
            return new FTContainsIndex(this.info, this.expr, ie, ic);
        }
        FTIndexAccess root = new FTIndexAccess(this.info, ie, ic);
        return this.expr instanceof Context ? root : ((AxisPath)this.expr).invertPath(root, ic.step);
    }

    @Override
    public final boolean uses(Expr.Use u) {
        return this.expr.uses(u) || this.ftexpr.uses(u);
    }

    @Override
    public final int count(Var v) {
        return this.expr.count(v) + this.ftexpr.count(v);
    }

    @Override
    public final boolean removable(Var v) {
        return this.expr.removable(v) && this.ftexpr.removable(v);
    }

    @Override
    public final Expr remove(Var v) {
        this.expr = this.expr.remove(v);
        this.ftexpr = this.ftexpr.remove(v);
        return this;
    }

    @Override
    public boolean databases(StringList db) {
        return this.expr.databases(db) && this.ftexpr.databases(db);
    }

    @Override
    public final void plan(FElem plan) {
        this.addPlan(plan, this.planElem(new Object[0]), this.expr, this.ftexpr);
    }

    @Override
    public String toString() {
        return this.expr + " " + "contains" + ' ' + "text" + ' ' + this.ftexpr;
    }
}

