/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.expr.VarRef;
import org.basex.query.func.DynamicFunc;
import org.basex.query.func.Function;
import org.basex.query.func.Functions;
import org.basex.query.func.PartFunc;
import org.basex.query.func.StandardFunc;
import org.basex.query.iter.Iter;
import org.basex.query.util.Err;
import org.basex.query.util.Var;
import org.basex.query.value.Value;
import org.basex.query.value.item.FItem;
import org.basex.query.value.item.Int;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.FuncType;
import org.basex.util.InputInfo;

public final class FNFunc
extends StandardFunc {
    public FNFunc(InputInfo ii, Function f, Expr ... e) {
        super(ii, f, e);
    }

    @Override
    public Iter iter(QueryContext ctx) throws QueryException {
        switch (this.sig) {
            case MAP: {
                return this.map(ctx);
            }
            case FILTER: {
                return this.filter(ctx);
            }
            case MAP_PAIRS: {
                return this.zip(ctx);
            }
            case FOLD_LEFT: {
                return this.foldLeft(ctx);
            }
            case FOLD_RIGHT: {
                return this.foldRight(ctx);
            }
        }
        return super.iter(ctx);
    }

    @Override
    public Item item(QueryContext ctx, InputInfo ii) throws QueryException {
        switch (this.sig) {
            case FUNCTION_ARITY: {
                return Int.get(this.getFun(0, FuncType.ANY_FUN, ctx).arity());
            }
            case FUNCTION_NAME: {
                return this.getFun(0, FuncType.ANY_FUN, ctx).fName();
            }
            case PARTIAL_APPLY: {
                return this.partApp(ctx, ii);
            }
            case FUNCTION_LOOKUP: {
                return this.lookup(ctx, ii);
            }
        }
        return super.item(ctx, ii);
    }

    private Item lookup(QueryContext ctx, InputInfo ii) throws QueryException {
        QNm name = (QNm)this.checkType(this.expr[0].item(ctx, ii), AtomType.QNM);
        long arity = this.checkItr(this.expr[1], ctx);
        try {
            return Functions.get(name, arity, true, ctx, ii);
        }
        catch (QueryException e) {
            return null;
        }
    }

    private Item partApp(QueryContext ctx, InputInfo ii) throws QueryException {
        FItem f = this.getFun(0, FuncType.ANY_FUN, ctx);
        long pos = this.expr.length == 2 ? 0L : this.checkItr(this.expr[2], ctx) - 1L;
        int arity = f.arity();
        if (pos < 0L || pos >= (long)arity) {
            Err.INVPOS.thrw(ii, f.description(), pos + 1L);
        }
        FuncType ft = (FuncType)f.type;
        Var[] vars = new Var[arity - 1];
        Expr[] vals = new Expr[arity];
        vals[(int)pos] = this.expr[1];
        int i = 0;
        int j = 0;
        while (i < arity - 1) {
            if ((long)i == pos) {
                ++j;
            }
            vars[i] = ctx.uniqueVar(ii, ft.args[j]);
            vals[j] = new VarRef(ii, vars[i]);
            ++i;
            ++j;
        }
        return new PartFunc(ii, new DynamicFunc(ii, (Expr)f, vals), vars).compile(ctx).item(ctx, ii);
    }

    private Iter map(final QueryContext ctx) throws QueryException {
        final FItem f = this.withArity(0, 1, ctx);
        final Iter xs = this.expr[1].iter(ctx);
        return new Iter(){
            Iter ys = Empty.ITER;

            @Override
            public Item next() throws QueryException {
                Item it;
                while ((it = this.ys.next()) == null) {
                    Item x = xs.next();
                    if (x == null) {
                        return null;
                    }
                    this.ys = f.invIter(ctx, FNFunc.this.info, x);
                }
                return it;
            }
        };
    }

    private Iter filter(final QueryContext ctx) throws QueryException {
        final FItem f = this.withArity(0, 1, ctx);
        final Iter xs = this.expr[1].iter(ctx);
        return new Iter(){

            @Override
            public Item next() throws QueryException {
                Item it;
                do {
                    if ((it = xs.next()) != null) continue;
                    return null;
                } while (!FNFunc.this.checkBln(FNFunc.this.checkNoEmpty(f.invItem(ctx, FNFunc.this.info, it)), ctx));
                return it;
            }
        };
    }

    private Iter zip(final QueryContext ctx) throws QueryException {
        final FItem zipper = this.withArity(0, 2, ctx);
        final Iter xs = this.expr[1].iter(ctx);
        final Iter ys = this.expr[2].iter(ctx);
        return new Iter(){
            Iter zs = Empty.ITER;

            @Override
            public Item next() throws QueryException {
                Item it;
                while ((it = this.zs.next()) == null) {
                    Item x = xs.next();
                    Item y = ys.next();
                    if (x == null || y == null) {
                        return null;
                    }
                    this.zs = zipper.invIter(ctx, FNFunc.this.info, x, y);
                }
                return it;
            }
        };
    }

    private Iter foldLeft(QueryContext ctx) throws QueryException {
        FItem f = this.withArity(0, 2, ctx);
        Iter xs = this.expr[2].iter(ctx);
        Item x = xs.next();
        if (x == null) {
            return this.expr[1].iter(ctx);
        }
        Value sum = ctx.value(this.expr[1]);
        do {
            sum = f.invValue(ctx, this.info, sum, x);
        } while ((x = xs.next()) != null);
        return sum.iter();
    }

    private Iter foldRight(QueryContext ctx) throws QueryException {
        FItem f = this.withArity(0, 2, ctx);
        Value xs = ctx.value(this.expr[2]);
        if (xs.isEmpty()) {
            return this.expr[1].iter(ctx);
        }
        Value res = ctx.value(this.expr[1]);
        long i = xs.size();
        while (--i >= 0L) {
            res = f.invValue(ctx, this.info, xs.itemAt(i), res);
        }
        return res.iter();
    }

    private FItem getFun(int p, FuncType t, QueryContext ctx) throws QueryException {
        return (FItem)this.checkType(this.checkItem(this.expr[p], ctx), t);
    }

    private FItem withArity(int p, int a, QueryContext ctx) throws QueryException {
        Item f = this.checkItem(this.expr[p], ctx);
        if (!f.type.isFunction() || ((FItem)f).arity() != a) {
            Err.type(this, FuncType.arity(a), f);
        }
        return (FItem)f;
    }

    @Override
    public boolean uses(Expr.Use u) {
        return u == Expr.Use.CTX && FNFunc.oneOf(this.sig, Function.PARTIAL_APPLY, Function.FUNCTION_LOOKUP) || u == Expr.Use.X30 || super.uses(u);
    }
}

