/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import javax.xml.datatype.DatatypeConstants;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import org.basex.core.Perm;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryModule;
import org.basex.query.QueryText;
import org.basex.query.expr.Arr;
import org.basex.query.expr.Expr;
import org.basex.query.func.JavaFunc;
import org.basex.query.func.JavaModuleFunc;
import org.basex.query.iter.Iter;
import org.basex.query.iter.ValueBuilder;
import org.basex.query.util.Err;
import org.basex.query.util.pkg.ModuleLoader;
import org.basex.query.value.Value;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Dbl;
import org.basex.query.value.item.Flt;
import org.basex.query.value.item.Int;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Jav;
import org.basex.query.value.item.QNm;
import org.basex.query.value.item.Str;
import org.basex.query.value.seq.ByteSeq;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.seq.Seq;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.Type;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public abstract class JavaMapping
extends Arr {
    static final String NEW = "new";
    private static final Class<?>[] JAVA = new Class[]{String.class, Boolean.TYPE, Boolean.class, Byte.TYPE, Byte.class, Short.TYPE, Short.class, Integer.TYPE, Integer.class, Long.TYPE, Long.class, Float.TYPE, Float.class, Double.TYPE, Double.class, BigDecimal.class, BigInteger.class, QName.class, Character.TYPE, Character.class, URI.class, URL.class};
    private static final Type[] XQUERY = new Type[]{AtomType.STR, AtomType.BLN, AtomType.BLN, AtomType.BYT, AtomType.BYT, AtomType.SHR, AtomType.SHR, AtomType.INT, AtomType.INT, AtomType.LNG, AtomType.LNG, AtomType.FLT, AtomType.FLT, AtomType.DBL, AtomType.DBL, AtomType.DEC, AtomType.ITR, AtomType.QNM, AtomType.STR, AtomType.STR, AtomType.URI, AtomType.URI};

    JavaMapping(InputInfo ii, Expr[] a) {
        super(ii, a);
    }

    @Override
    public final Iter iter(QueryContext ctx) throws QueryException {
        return this.value(ctx).iter();
    }

    @Override
    public final Value value(QueryContext ctx) throws QueryException {
        Value[] args = new Value[this.expr.length];
        for (int a = 0; a < this.expr.length; ++a) {
            args[a] = ctx.value(this.expr[a]);
        }
        return JavaMapping.toValue(this.eval(args, ctx));
    }

    protected abstract Object eval(Value[] var1, QueryContext var2) throws QueryException;

    public static Value toValue(Object res) throws QueryException {
        if (res == null) {
            return Empty.SEQ;
        }
        if (res instanceof Value) {
            return (Value)res;
        }
        if (res instanceof Iter) {
            return ((Iter)res).value();
        }
        Type type = JavaMapping.type(res);
        if (type != null) {
            return type.cast(res, null);
        }
        if (res instanceof char[]) {
            return Str.get(new String((char[])res));
        }
        if (!res.getClass().isArray()) {
            return new Jav(res);
        }
        int s = Array.getLength(res);
        if (s == 0) {
            return Empty.SEQ;
        }
        if (res instanceof byte[]) {
            byte[] values = (byte[])res;
            return s > 1 ? new ByteSeq(values) : new Int(values[0], AtomType.BYT);
        }
        Item[] items = new Item[s];
        if (res instanceof boolean[]) {
            type = AtomType.BLN;
            boolean[] values = (boolean[])res;
            for (int v = 0; v < s; ++v) {
                items[v] = Bln.get(values[v]);
            }
        } else if (res instanceof short[]) {
            type = AtomType.SHR;
            short[] values = (short[])res;
            for (int v = 0; v < s; ++v) {
                items[v] = new Int(values[v], type);
            }
        } else if (res instanceof int[]) {
            type = AtomType.INT;
            int[] values = (int[])res;
            for (int v = 0; v < s; ++v) {
                items[v] = new Int(values[v], type);
            }
        } else if (res instanceof long[]) {
            type = AtomType.ITR;
            long[] values = (long[])res;
            for (int v = 0; v < s; ++v) {
                items[v] = Int.get(values[v]);
            }
        } else if (res instanceof float[]) {
            type = AtomType.FLT;
            float[] values = (float[])res;
            for (int v = 0; v < s; ++v) {
                items[v] = Flt.get(values[v]);
            }
        } else if (res instanceof double[]) {
            type = AtomType.DBL;
            double[] values = (double[])res;
            for (int v = 0; v < s; ++v) {
                items[v] = Dbl.get(values[v]);
            }
        } else {
            ValueBuilder vb = new ValueBuilder();
            for (Object o : (Object[])res) {
                vb.add(o instanceof Value ? (Value)o : new Jav(o));
            }
            return vb.value();
        }
        return Seq.get(items, s, type);
    }

    static JavaMapping get(QNm qname, Expr[] args, QueryContext ctx, InputInfo ii) throws QueryException {
        Object jm;
        byte[] uri = qname.uri();
        byte[] ln = qname.local();
        boolean java = Token.startsWith(uri, QueryText.JAVAPREF);
        QNm nm = new QNm(ln, java ? Token.substring(uri, QueryText.JAVAPREF.length) : uri);
        TokenBuilder tb = new TokenBuilder();
        boolean dash = false;
        for (int p = 0; p < ln.length; p += Token.cl(ln, p)) {
            int ch = Token.cp(ln, p);
            if (dash) {
                tb.add(Character.toUpperCase(ch));
                dash = false;
                continue;
            }
            boolean bl = dash = ch == 45;
            if (dash) continue;
            tb.add(ch);
        }
        String name = tb.toString();
        String path = Token.string(nm.uri());
        String p = ModuleLoader.uri2path(path);
        if (p != null) {
            path = p;
        }
        if ((jm = ctx.modules.findImport(path = path.replace("/", ".").substring(1))) != null) {
            Method meth = null;
            for (Method m : jm.getClass().getMethods()) {
                if (!m.getName().equals(name) || m.getParameterTypes().length != args.length) continue;
                if (meth != null) {
                    Err.JAVAAMB.thrw(ii, path + ':' + name);
                }
                meth = m;
            }
            if (meth != null) {
                Perm perm = Perm.ADMIN;
                QueryModule.Requires req = meth.getAnnotation(QueryModule.Requires.class);
                if (req != null) {
                    perm = Perm.get(req.value().name());
                }
                if (!ctx.context.user.has(perm)) {
                    return null;
                }
                return new JavaModuleFunc(ii, jm, meth, args);
            }
            Err.WHICHJAVA.thrw(ii, path + ':' + name);
        }
        if (!ctx.context.user.has(Perm.ADMIN)) {
            return null;
        }
        try {
            return new JavaFunc(ii, ctx.modules.findClass(path), name, args);
        }
        catch (ClassNotFoundException ex) {
            if (java) {
                throw Err.WHICHJAVA.thrw(ii, new Object[]{uri});
            }
        }
        catch (Throwable th) {
            Util.debug(th);
            throw Err.INITJAVA.thrw(ii, th);
        }
        return null;
    }

    public static Type type(Object o) {
        Type t = JavaMapping.type(o.getClass());
        if (t != null) {
            return t;
        }
        if (o instanceof Element) {
            return NodeType.ELM;
        }
        if (o instanceof Document) {
            return NodeType.DOC;
        }
        if (o instanceof DocumentFragment) {
            return NodeType.DOC;
        }
        if (o instanceof Attr) {
            return NodeType.ATT;
        }
        if (o instanceof Comment) {
            return NodeType.COM;
        }
        if (o instanceof ProcessingInstruction) {
            return NodeType.PI;
        }
        if (o instanceof Text) {
            return NodeType.TXT;
        }
        if (o instanceof Duration) {
            Duration d = (Duration)o;
            return !d.isSet(DatatypeConstants.YEARS) && !d.isSet(DatatypeConstants.MONTHS) ? AtomType.DTD : (!d.isSet(DatatypeConstants.HOURS) && !d.isSet(DatatypeConstants.MINUTES) && !d.isSet(DatatypeConstants.SECONDS) ? AtomType.YMD : AtomType.DUR);
        }
        if (o instanceof XMLGregorianCalendar) {
            QName type = ((XMLGregorianCalendar)o).getXMLSchemaType();
            if (type == DatatypeConstants.DATE) {
                return AtomType.DAT;
            }
            if (type == DatatypeConstants.DATETIME) {
                return AtomType.DTM;
            }
            if (type == DatatypeConstants.TIME) {
                return AtomType.TIM;
            }
            if (type == DatatypeConstants.GYEARMONTH) {
                return AtomType.YMO;
            }
            if (type == DatatypeConstants.GMONTHDAY) {
                return AtomType.MDA;
            }
            if (type == DatatypeConstants.GYEAR) {
                return AtomType.YEA;
            }
            if (type == DatatypeConstants.GMONTH) {
                return AtomType.MON;
            }
            if (type == DatatypeConstants.GDAY) {
                return AtomType.DAY;
            }
        }
        return null;
    }

    protected static Type type(Class<?> type) {
        for (int j = 0; j < JAVA.length; ++j) {
            if (!JAVA[j].isAssignableFrom(type)) continue;
            return XQUERY[j];
        }
        return null;
    }

    protected static String foundArgs(Value[] args) {
        StringBuilder found = new StringBuilder();
        for (Value a : args) {
            if (found.length() != 0) {
                found.append(", ");
            }
            found.append(a.type());
        }
        return found.toString();
    }

    @Override
    public boolean uses(Expr.Use u) {
        return u == Expr.Use.NDT || super.uses(u);
    }
}

