/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.item;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.value.item.ADate;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Num;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.Type;
import org.basex.util.InputInfo;
import org.basex.util.Token;

public class Int
extends Num {
    private static final Int[] NUMS = new Int[128];
    private final long val;

    private Int(long v) {
        this(v, AtomType.ITR);
    }

    public Int(long v, Type t) {
        super(t);
        this.val = v;
    }

    public Int(ADate d) {
        this(d.xc.toGregorianCalendar().getTimeInMillis(), AtomType.LNG);
    }

    public static Int get(long v) {
        return v >= 0L && v < (long)NUMS.length ? NUMS[(int)v] : new Int(v);
    }

    public static Int get(long v, Type t) {
        return t == AtomType.ITR ? Int.get(v) : new Int(v, t);
    }

    @Override
    public final byte[] string(InputInfo ii) {
        return this.val == 0L ? Token.ZERO : Token.token(this.val);
    }

    @Override
    public final boolean bool(InputInfo ii) {
        return this.val != 0L;
    }

    @Override
    public final long itr(InputInfo ii) {
        return this.val;
    }

    @Override
    public final float flt(InputInfo ii) {
        return this.val;
    }

    @Override
    public final double dbl(InputInfo ii) {
        return this.val;
    }

    @Override
    public final BigDecimal dec(InputInfo ii) {
        return BigDecimal.valueOf(this.val);
    }

    @Override
    public final boolean eq(InputInfo ii, Item it) throws QueryException {
        return it instanceof Int ? this.val == ((Int)it).val : (double)this.val == it.dbl(ii);
    }

    @Override
    public final int diff(InputInfo ii, Item it) throws QueryException {
        if (it instanceof Int) {
            long i = ((Int)it).val;
            return this.val < i ? -1 : (this.val > i ? 1 : 0);
        }
        double n = it.dbl(ii);
        return Double.isNaN(n) ? Integer.MIN_VALUE : ((double)this.val < n ? -1 : ((double)this.val > n ? 1 : 0));
    }

    @Override
    public final Object toJava() {
        switch ((AtomType)this.type) {
            case BYT: {
                return (byte)this.val;
            }
            case SHR: 
            case UBY: {
                return (short)this.val;
            }
            case INT: 
            case USH: {
                return (int)this.val;
            }
            case LNG: 
            case UIN: {
                return this.val;
            }
        }
        return new BigInteger(this.toString());
    }

    @Override
    public final boolean sameAs(Expr cmp) {
        if (!(cmp instanceof Int)) {
            return false;
        }
        Int i = (Int)cmp;
        return this.type == i.type && this.val == i.val;
    }

    public static long parse(byte[] val, InputInfo ii) throws QueryException {
        long l = Token.toLong(val);
        if (l != Long.MIN_VALUE) {
            return l;
        }
        try {
            return Long.parseLong(Token.string(val).trim());
        }
        catch (NumberFormatException ex) {
            throw NUMS[0].castErr(val, ii);
        }
    }

    static {
        for (int i = 0; i < NUMS.length; ++i) {
            Int.NUMS[i] = new Int(i);
        }
    }
}

