/*
 * Decompiled with CFR 0.152.
 */
package org.basex.server;

import java.io.FileOutputStream;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.basex.core.Context;
import org.basex.core.Prop;
import org.basex.io.IOFile;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;

public final class Log {
    private static final DateFormat DATE = new SimpleDateFormat("yyyy-MM-dd");
    private static final DateFormat TIME = new SimpleDateFormat("HH:mm:ss.SSS");
    private final boolean quiet;
    private final IOFile dir;
    private String start;
    private FileOutputStream fos;

    public Log(Context ctx, boolean q) {
        this.dir = ctx.mprop.dbpath(".logs");
        this.quiet = q;
        if (!q) {
            this.create(new Date());
        }
    }

    public synchronized void error(Throwable th) {
        Util.stack(th);
        if (!this.quiet) {
            this.write(Util.bug(th));
        }
    }

    public synchronized void write(Object ... str) {
        if (this.quiet) {
            return;
        }
        Date now = new Date();
        if (!this.start.equals(DATE.format(now))) {
            this.close();
            this.create(now);
        }
        TokenBuilder tb = new TokenBuilder(TIME.format(now));
        for (Object s : str) {
            tb.add(9);
            tb.add(Token.chop(Token.token(s.toString().replaceAll("[\\r\\n ]+", " ")), 1000));
        }
        tb.add(Prop.NL);
        try {
            this.fos.write(tb.finish());
            this.fos.flush();
        }
        catch (Exception ex) {
            Util.debug(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void create(Date d) {
        this.dir.md();
        DateFormat dateFormat = DATE;
        synchronized (dateFormat) {
            this.start = DATE.format(d);
        }
        try {
            this.fos = new FileOutputStream(new IOFile(this.dir, this.start + ".log").file(), true);
        }
        catch (IOException ex) {
            Util.stack(ex);
        }
    }

    private void close() {
        try {
            this.fos.close();
            this.fos = null;
        }
        catch (IOException ex) {
            Util.stack(ex);
        }
    }
}

