/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.projects;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import nl.mpi.arbil.ui.ArbilWindowManager;
import nl.mpi.arbil.userstorage.SessionStorage;
import nl.mpi.kinnate.entityindexer.EntityCollection;
import nl.mpi.kinnate.entityindexer.EntityServiceException;
import nl.mpi.kinnate.projects.ProjectRecord;
import nl.mpi.kinnate.projects.RecentProjects;
import nl.mpi.kinnate.ui.KinDiagramPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectManager {
    private final File recentProjectsFile;
    private ProjectRecord defaultProject = null;
    private HashMap<ProjectRecord, EntityCollection> projectEntityCollectionMap = new HashMap();
    private final ArbilWindowManager dialogHandler;

    public ProjectManager(SessionStorage sessionStorage, ArbilWindowManager dialogHandler) {
        this.recentProjectsFile = new File(sessionStorage.getApplicationSettingsDirectory(), "RecentProjects.xml");
        this.dialogHandler = dialogHandler;
    }

    @Deprecated
    public ProjectRecord getDefaultProject(SessionStorage sessionStorage) {
        if (this.defaultProject == null) {
            try {
                this.defaultProject = this.loadProjectRecord(sessionStorage.getProjectDirectory());
            }
            catch (JAXBException exception) {
                this.defaultProject = new ProjectRecord(sessionStorage.getProjectDirectory(), sessionStorage.getProjectDirectory().getName(), "nl-mpi-kinnate");
            }
        }
        return this.defaultProject;
    }

    public List<ProjectRecord> getProjectRecords(SessionStorage sessionStorage) throws JAXBException {
        return this.getRecentProjectsList().getProjectRecords();
    }

    public void moveProjectRecordToTop(ProjectRecord projectRecord, KinDiagramPanel diagramPanel) throws JAXBException {
        RecentProjects recentProjectsList = this.getRecentProjectsList();
        this.checkProjectChangeDate(recentProjectsList, projectRecord, diagramPanel);
        recentProjectsList.moveProjectRecordToTop(projectRecord);
        this.saveRecentProjectsList(recentProjectsList);
    }

    public void clearRecentProjectsList() throws JAXBException {
        RecentProjects recentProjectsList = this.getRecentProjectsList();
        recentProjectsList.clearList();
        this.saveRecentProjectsList(recentProjectsList);
    }

    public EntityCollection getEntityCollectionForProject(ProjectRecord projectRecord) throws EntityServiceException {
        if (this.projectEntityCollectionMap.containsKey(projectRecord)) {
            return this.projectEntityCollectionMap.get(projectRecord);
        }
        EntityCollection entityCollection = new EntityCollection(this, projectRecord);
        this.projectEntityCollectionMap.put(projectRecord, entityCollection);
        return entityCollection;
    }

    public RecentProjects getRecentProjectsList() throws JAXBException {
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{RecentProjects.class});
        Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
        if (this.recentProjectsFile.exists()) {
            return (RecentProjects)unmarshaller.unmarshal(this.recentProjectsFile);
        }
        return new RecentProjects();
    }

    private void saveRecentProjectsList(RecentProjects recentProjects) throws JAXBException {
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{RecentProjects.class});
        Marshaller marshaller = jaxbContext.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        marshaller.marshal((Object)recentProjects, this.recentProjectsFile);
    }

    public void saveProjectRecord(ProjectRecord projectRecord, boolean updateInRecentList, boolean updateInProjectDirectory) throws JAXBException {
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ProjectRecord.class});
        if (updateInProjectDirectory) {
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.marshal((Object)projectRecord, new File(projectRecord.projectDirectory, "kinoath.proj"));
        }
        if (updateInRecentList) {
            RecentProjects recentProjectsList = this.getRecentProjectsList();
            recentProjectsList.updateProjectRecord(projectRecord);
            this.saveRecentProjectsList(recentProjectsList);
        }
    }

    public ProjectRecord loadProjectRecord(File projectDirectory) throws JAXBException {
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ProjectRecord.class});
        Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
        String kinoathproj = "kinoath.proj";
        File projectFile = projectDirectory.isFile() && "kinoath.proj".equals(projectDirectory.getName()) ? projectDirectory : new File(projectDirectory, "kinoath.proj");
        ProjectRecord projectRecord = (ProjectRecord)unmarshaller.unmarshal(projectFile);
        projectRecord.setProjectDirectory(projectFile.getParentFile());
        return projectRecord;
    }

    private void checkProjectChangeDate(RecentProjects recentProjectsList, ProjectRecord projectRecord, KinDiagramPanel diagramPanel) {
        for (ProjectRecord recentProjectRecord : recentProjectsList.getProjectRecords()) {
            if (!recentProjectRecord.equals(projectRecord)) continue;
            this.checkProjectChangeDate(recentProjectRecord, projectRecord, diagramPanel);
            return;
        }
        this.recreateDatabse(projectRecord, diagramPanel);
    }

    private void checkProjectChangeDate(ProjectRecord databaseProjectRecord, final ProjectRecord projectRecord, final KinDiagramPanel diagramPanel) {
        if (!databaseProjectRecord.getLastChangeId().equals(projectRecord.getLastChangeId())) {
            new Thread(new Runnable(){

                public void run() {
                    if (0 == ProjectManager.this.dialogHandler.showDialogBox("The project '" + projectRecord.projectName + "' has been modified externally,\ndo you want to update the database so that the changes are visible?", "KinOath Project Check", 2, 3)) {
                        try {
                            diagramPanel.showProgressBar();
                            ProjectManager.this.getEntityCollectionForProject(projectRecord).recreateDatabase();
                        }
                        catch (EntityServiceException exception) {
                            ProjectManager.this.dialogHandler.addMessageDialogToQueue("Database update failed: " + exception, "KinOath Project Check");
                        }
                        diagramPanel.clearProgressBar();
                    }
                }
            }).start();
        }
    }

    private void recreateDatabse(final ProjectRecord projectRecord, final KinDiagramPanel diagramPanel) {
        new Thread(new Runnable(){

            public void run() {
                try {
                    diagramPanel.showProgressBar();
                    ProjectManager.this.getEntityCollectionForProject(projectRecord).recreateDatabase();
                }
                catch (EntityServiceException exception) {
                    ProjectManager.this.dialogHandler.addMessageDialogToQueue("Database update failed: " + exception, "KinOath Project Check");
                }
                diagramPanel.clearProgressBar();
            }
        }).start();
    }
}

