/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.svg;

import nl.mpi.kinnate.svg.RelationDragHandle;
import org.w3c.dom.Element;

public class GraphicsDragHandle
extends RelationDragHandle {
    protected Element graphicsElement;
    protected Element highlightElement;
    protected Element highlightRectElement;
    private String xAttribute;
    private String yAttribute;
    private boolean isCenteredElement = false;

    public GraphicsDragHandle(Element graphicsElement, Element highlightElement, Element highlightRectElement, float elementStartX, float elementStartY, float mouseStartX, float mouseStartY, double diagramScaleFactor) {
        super(null, null, elementStartX, elementStartY, mouseStartX, mouseStartY, diagramScaleFactor);
        this.graphicsElement = graphicsElement;
        this.highlightElement = highlightElement;
        this.highlightRectElement = highlightRectElement;
        String elementType = graphicsElement.getTagName();
        if (elementType.equals("circle")) {
            this.isCenteredElement = true;
            this.xAttribute = "r";
            this.yAttribute = null;
        } else if (elementType.equals("rect")) {
            this.xAttribute = "width";
            this.yAttribute = "height";
        } else if (elementType.equals("ellipse")) {
            this.isCenteredElement = true;
            this.xAttribute = "rx";
            this.yAttribute = "ry";
        }
    }

    protected void updatedElement(float localDragNodeX, float localDragNodeY, int paddingDistance) {
        float dragNodeX = this.getTranslatedX(localDragNodeX);
        float dragNodeY = this.getTranslatedY(localDragNodeY);
        int minSize = 3;
        if (dragNodeX < (float)(paddingDistance + minSize)) {
            dragNodeX = paddingDistance + minSize;
        }
        if (dragNodeY < (float)(paddingDistance + minSize)) {
            dragNodeY = paddingDistance + minSize;
        }
        this.graphicsElement.setAttribute(this.xAttribute, Float.toString(dragNodeX - (float)paddingDistance));
        if (this.yAttribute != null) {
            this.graphicsElement.setAttribute(this.yAttribute, Float.toString(dragNodeY - (float)paddingDistance));
        } else {
            dragNodeY = dragNodeX;
        }
        if (this.isCenteredElement) {
            this.highlightRectElement.setAttribute("x", Float.toString(-dragNodeX));
            this.highlightRectElement.setAttribute("y", Float.toString(-dragNodeY));
            this.highlightRectElement.setAttribute("width", Float.toString(dragNodeX * 2.0f) + paddingDistance);
            this.highlightRectElement.setAttribute("height", Float.toString(dragNodeY * 2.0f) + paddingDistance);
        } else {
            this.highlightRectElement.setAttribute("width", Float.toString(dragNodeX + (float)paddingDistance));
            this.highlightRectElement.setAttribute("height", Float.toString(dragNodeY + (float)paddingDistance));
        }
        this.highlightElement.setAttribute("cx", Float.toString(dragNodeX));
        this.highlightElement.setAttribute("cy", Float.toString(dragNodeY));
    }
}

