/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import nl.mpi.arbil.ui.ArbilWindowManager;
import nl.mpi.arbil.userstorage.SessionStorage;
import nl.mpi.arbil.util.MessageDialogHandler;
import nl.mpi.kinnate.entityindexer.EntityCollection;
import nl.mpi.kinnate.kindocument.ProfileManager;
import nl.mpi.kinnate.svg.DataStoreSvg;
import nl.mpi.kinnate.svg.GraphPanel;
import nl.mpi.kinnate.ui.FieldSelectionList;
import nl.mpi.kinnate.ui.KinDiagramPanel;
import nl.mpi.kinnate.ui.TableCellDragHandler;
import nl.mpi.kinnate.ui.entityprofiles.CmdiProfileSelectionPanel;
import nl.mpi.kinnate.ui.kintypeeditor.KinTypeDefinitions;
import nl.mpi.kinnate.ui.relationsettings.RelationSettingsPanel;

public class DiagramSettingsPanel
extends JPanel {
    public DiagramSettingsPanel(KinDiagramPanel kinDiagramPanel, EntityCollection entityCollection, SessionStorage sessionStorage, GraphPanel graphPanel, ArbilWindowManager dialogHandler, TableCellDragHandler tableCellDragHandler) {
        super(new BorderLayout());
        this.setName("Diagram Settings");
        JTabbedPane jTabbedPane = new JTabbedPane();
        ProfileManager profileManager = new ProfileManager(sessionStorage, (MessageDialogHandler)dialogHandler);
        CmdiProfileSelectionPanel cmdiProfileSelectionPanel = new CmdiProfileSelectionPanel("Entity Profiles", profileManager, graphPanel);
        profileManager.loadProfiles(false, cmdiProfileSelectionPanel, graphPanel);
        graphPanel.getIndexParameters().symbolFieldsFields.setParent(graphPanel.getIndexParameters());
        graphPanel.getIndexParameters().labelFields.setParent(graphPanel.getIndexParameters());
        jTabbedPane.addTab("Kin Type Definitions", new KinTypeDefinitions("Kin Type Definitions", kinDiagramPanel, graphPanel.dataStoreSvg));
        jTabbedPane.addTab("Relation Type Definitions", new RelationSettingsPanel("Relation Type Definitions", kinDiagramPanel, graphPanel.dataStoreSvg, dialogHandler));
        if (graphPanel.dataStoreSvg.diagramMode != DataStoreSvg.DiagramMode.FreeForm) {
            JScrollPane symbolFieldsPanel = new JScrollPane(new FieldSelectionList(entityCollection, kinDiagramPanel, graphPanel.getIndexParameters().symbolFieldsFields, tableCellDragHandler));
            JScrollPane labelFieldsPanel = new JScrollPane(new FieldSelectionList(entityCollection, kinDiagramPanel, graphPanel.getIndexParameters().labelFields, tableCellDragHandler));
            symbolFieldsPanel.setName("Symbol Fields");
            labelFieldsPanel.setName("Label Fields");
            jTabbedPane.addTab("Symbol Fields", symbolFieldsPanel);
            jTabbedPane.addTab("Label Fields", labelFieldsPanel);
            jTabbedPane.addTab("Entity Profiles", cmdiProfileSelectionPanel);
        }
        this.add((Component)jTabbedPane, "Center");
    }
}

