/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.ui.menu;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.filechooser.FileFilter;
import nl.mpi.arbil.userstorage.SessionStorage;
import nl.mpi.arbil.util.BugCatcherManager;
import nl.mpi.arbil.util.MessageDialogHandler;
import nl.mpi.flap.plugin.PluginDialogHandler;
import nl.mpi.kinnate.SavePanel;
import nl.mpi.kinnate.entityindexer.EntityCollection;
import nl.mpi.kinnate.entityindexer.EntityServiceException;
import nl.mpi.kinnate.export.ExportToR;
import nl.mpi.kinnate.gedcomimport.ImportException;
import nl.mpi.kinnate.projects.ProjectManager;
import nl.mpi.kinnate.svg.DataStoreSvg;
import nl.mpi.kinnate.svg.DiagramTranscoder;
import nl.mpi.kinnate.ui.DiagramTranscoderPanel;
import nl.mpi.kinnate.ui.ImportSamplesFileMenu;
import nl.mpi.kinnate.ui.KinDiagramPanel;
import nl.mpi.kinnate.ui.menu.DocumentNewMenu;
import nl.mpi.kinnate.ui.menu.ProjectFileMenu;
import nl.mpi.kinnate.ui.menu.RecentFileMenu;
import nl.mpi.kinnate.ui.menu.SamplesFileMenu;
import nl.mpi.kinnate.ui.window.AbstractDiagramManager;
import org.apache.batik.transcoder.TranscoderException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileMenu
extends JMenu {
    private JMenuItem importGedcomFile;
    private JMenuItem closeTabMenuItem;
    private JMenuItem exitApplication;
    private JMenuItem exportToR;
    private JMenu jMenu1;
    private JMenu jMenu2;
    private JPopupMenu.Separator jSeparator1;
    private JPopupMenu.Separator jSeparator2;
    private JPopupMenu.Separator jSeparator3;
    private JPopupMenu.Separator jSeparator4;
    private JPopupMenu.Separator jSeparator5;
    private JMenuItem newDiagramMenuItem;
    private JMenuItem openDiagram;
    private RecentFileMenu recentFileMenu;
    private JMenuItem projectNewMenu;
    private JMenuItem projectOpenMenu;
    private ProjectFileMenu projectRecentMenu;
    private JMenuItem saveAsGlobalDefaultMenuItem;
    private JMenuItem saveAsProjectDefaultMenuItem;
    private JMenuItem saveDiagram;
    private JMenuItem saveDiagramAs;
    private JMenuItem savePdfMenuItem;
    private AbstractDiagramManager diagramWindowManager;
    private SessionStorage sessionStorage;
    private MessageDialogHandler dialogHandler;
    private Component parentComponent;
    private ProjectManager projectManager;

    public FileMenu(AbstractDiagramManager diagramWindowManager, SessionStorage sessionStorage, MessageDialogHandler dialogHandler, Component parentComponent, ProjectManager projectManager) {
        this.diagramWindowManager = diagramWindowManager;
        this.sessionStorage = sessionStorage;
        this.projectManager = projectManager;
        this.dialogHandler = dialogHandler;
        this.diagramWindowManager = diagramWindowManager;
        this.parentComponent = parentComponent;
        this.importGedcomFile = new JMenuItem();
        this.jSeparator1 = new JPopupMenu.Separator();
        this.newDiagramMenuItem = new JMenuItem();
        this.openDiagram = new JMenuItem();
        this.recentFileMenu = new RecentFileMenu(diagramWindowManager, sessionStorage, parentComponent, dialogHandler);
        this.projectNewMenu = new JMenuItem();
        this.projectOpenMenu = new JMenuItem();
        this.projectRecentMenu = new ProjectFileMenu(diagramWindowManager, parentComponent, dialogHandler, projectManager);
        this.jMenu1 = new SamplesFileMenu(diagramWindowManager, dialogHandler, parentComponent);
        this.jMenu2 = new ImportSamplesFileMenu(diagramWindowManager, dialogHandler, parentComponent);
        this.jSeparator2 = new JPopupMenu.Separator();
        this.jSeparator4 = new JPopupMenu.Separator();
        this.saveDiagram = new JMenuItem();
        this.saveDiagramAs = new JMenuItem();
        this.savePdfMenuItem = new JMenuItem();
        this.exportToR = new JMenuItem();
        this.closeTabMenuItem = new JMenuItem();
        this.jSeparator3 = new JPopupMenu.Separator();
        this.saveAsGlobalDefaultMenuItem = new JMenuItem();
        this.saveAsProjectDefaultMenuItem = new JMenuItem();
        this.jSeparator5 = new JPopupMenu.Separator();
        this.exitApplication = new JMenuItem();
        this.setText("File");
        this.addMenuListener(new MenuListener(){

            public void menuSelected(MenuEvent evt) {
                FileMenu.this.fileMenuMenuSelected(evt);
            }

            public void menuDeselected(MenuEvent evt) {
            }

            public void menuCanceled(MenuEvent evt) {
            }
        });
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FileMenu.this.fileMenuActionPerformed(evt);
            }
        });
        this.newDiagramMenuItem.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        this.newDiagramMenuItem.setText("New (default diagram)");
        this.newDiagramMenuItem.setEnabled(KinDiagramPanel.getGlobalDefaultDiagramFile(sessionStorage).exists());
        this.newDiagramMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FileMenu.this.newDiagramMenuItemActionPerformed(evt);
            }
        });
        this.add(this.newDiagramMenuItem);
        DocumentNewMenu projectDiagramMenuItem = new DocumentNewMenu(diagramWindowManager, parentComponent, dialogHandler);
        projectDiagramMenuItem.setText("New Diagram of Type");
        this.add(projectDiagramMenuItem);
        this.openDiagram.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.openDiagram.setText("Open Diagram");
        this.openDiagram.setActionCommand("open");
        this.openDiagram.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FileMenu.this.openDiagramActionPerformed(evt);
            }
        });
        this.add(this.openDiagram);
        this.add(this.recentFileMenu);
        this.jMenu1.setText("Open Sample Diagram");
        this.add(this.jMenu1);
        this.add(new JPopupMenu.Separator());
        this.projectNewMenu.setText("New Project");
        this.projectNewMenu.setActionCommand("new");
        this.projectNewMenu.addActionListener(this.projectRecentMenu);
        this.add(this.projectNewMenu);
        this.projectOpenMenu.setText("Open Project");
        this.projectOpenMenu.setActionCommand("browse");
        this.projectOpenMenu.addActionListener(this.projectRecentMenu);
        this.add(this.projectOpenMenu);
        this.add(this.projectRecentMenu);
        this.importGedcomFile.setText("Import Gedcom / CSV / TIP File (into current project)");
        this.importGedcomFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FileMenu.this.importGedcomFileActionPerformed(evt);
            }
        });
        this.add(this.importGedcomFile);
        this.jMenu2.setText("Import Sample Data (into current project)");
        this.add(this.jMenu2);
        SavePanel currentSavePanel = diagramWindowManager.getCurrentSavePanel(parentComponent);
        if (currentSavePanel == null || currentSavePanel.getGraphPanel().dataStoreSvg.diagramMode != DataStoreSvg.DiagramMode.KinTypeQuery) {
            this.jMenu2.setEnabled(false);
            this.importGedcomFile.setEnabled(false);
        }
        this.add(this.jSeparator2);
        this.saveDiagram.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.saveDiagram.setText("Save");
        this.saveDiagram.setActionCommand("save");
        this.saveDiagram.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FileMenu.this.saveDiagramActionPerformed(evt);
            }
        });
        this.add(this.saveDiagram);
        this.saveDiagramAs.setAccelerator(KeyStroke.getKeyStroke(83, 3));
        this.saveDiagramAs.setText("Save As");
        this.saveDiagramAs.setActionCommand("saveas");
        this.saveDiagramAs.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FileMenu.this.saveDiagramAsActionPerformed(evt);
            }
        });
        this.add(this.saveDiagramAs);
        this.savePdfMenuItem.setText("Export as PDF/JPEG/PNG/TIFF");
        this.savePdfMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FileMenu.this.savePdfMenuItemActionPerformed(evt);
            }
        });
        this.add(this.savePdfMenuItem);
        this.exportToR.setText("Export for R / SPSS");
        this.exportToR.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FileMenu.this.exportToRActionPerformed(evt);
            }
        });
        this.add(this.exportToR);
        this.closeTabMenuItem.setAccelerator(KeyStroke.getKeyStroke(87, 2));
        this.closeTabMenuItem.setText("Close");
        this.closeTabMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FileMenu.this.closeTabMenuItemActionPerformed(evt);
            }
        });
        this.add(this.closeTabMenuItem);
        this.add(this.jSeparator3);
        this.saveAsGlobalDefaultMenuItem.setText("Save as Global Default Diagram");
        this.saveAsGlobalDefaultMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FileMenu.this.saveAsDefaultMenuItemActionPerformed(evt, true);
            }
        });
        this.add(this.saveAsGlobalDefaultMenuItem);
        this.saveAsProjectDefaultMenuItem.setText("Save as Project Default Diagram");
        this.saveAsProjectDefaultMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FileMenu.this.saveAsDefaultMenuItemActionPerformed(evt, false);
            }
        });
        this.add(this.saveAsProjectDefaultMenuItem);
        this.add(this.jSeparator5);
        this.exitApplication.setText("Exit");
        this.exitApplication.setActionCommand("exit");
        this.exitApplication.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FileMenu.this.exitApplicationActionPerformed(evt);
            }
        });
        this.add(this.exitApplication);
    }

    private void fileMenuActionPerformed(ActionEvent evt) {
    }

    private HashMap<String, FileFilter> getSvgFileFilter() {
        HashMap<String, FileFilter> fileFilterMap = new HashMap<String, FileFilter>(2);
        for (final String[] currentType : new String[][]{{"Kinship Diagram (SVG format)", ".svg"}}) {
            fileFilterMap.put(currentType[0], new FileFilter(){

                public boolean accept(File selectedFile) {
                    String extensionLowerCase = currentType[1].toLowerCase();
                    return selectedFile.exists() && (selectedFile.isDirectory() || selectedFile.getName().toLowerCase().endsWith(extensionLowerCase));
                }

                public String getDescription() {
                    return currentType[0];
                }
            });
        }
        return fileFilterMap;
    }

    private void openDiagramActionPerformed(ActionEvent evt) {
        File[] selectedFilesArray = this.dialogHandler.showFileSelectBox("Open Diagram", false, true, this.getSvgFileFilter(), PluginDialogHandler.DialogueType.open, null);
        Dimension parentSize = this.parentComponent.getSize();
        Point parentLocation = this.parentComponent.getLocation();
        int offset = 10;
        Rectangle windowRectangle = new Rectangle(parentLocation.x + offset, parentLocation.y + offset, parentSize.width - offset, parentSize.height - offset);
        if (selectedFilesArray != null) {
            for (File selectedFile : selectedFilesArray) {
                try {
                    this.diagramWindowManager.openDiagram(selectedFile.getName(), selectedFile.toURI(), true, windowRectangle);
                }
                catch (EntityServiceException entityServiceException) {
                    this.dialogHandler.addMessageDialogToQueue("Failed to create a new diagram: " + entityServiceException.getMessage(), "Open Diagram Error");
                }
            }
        }
    }

    private void saveDiagramActionPerformed(ActionEvent evt) {
        int tabIndex = Integer.valueOf(evt.getActionCommand());
        SavePanel savePanel = this.diagramWindowManager.getSavePanel(tabIndex);
        savePanel.saveToFile();
    }

    private void saveDiagramAsActionPerformed(ActionEvent evt) {
        File[] selectedFilesArray = this.dialogHandler.showFileSelectBox("Save Diagram As", false, false, this.getSvgFileFilter(), PluginDialogHandler.DialogueType.save, null);
        if (selectedFilesArray != null) {
            for (File selectedFile : selectedFilesArray) {
                if (!selectedFile.getName().toLowerCase().endsWith(".svg")) {
                    selectedFile = new File(selectedFile.getParentFile(), selectedFile.getName() + ".svg");
                }
                int tabIndex = Integer.valueOf(evt.getActionCommand());
                SavePanel savePanel = this.diagramWindowManager.getSavePanel(tabIndex);
                savePanel.saveToFile(selectedFile);
                RecentFileMenu.addRecentFile(this.sessionStorage, selectedFile);
                this.diagramWindowManager.setDiagramTitle(tabIndex, selectedFile.getName());
            }
        }
    }

    private void exitApplicationActionPerformed(ActionEvent evt) {
        if (this.diagramWindowManager.offerUserToSaveAll()) {
            System.exit(0);
        }
    }

    private void fileMenuMenuSelected(MenuEvent evt) {
        SavePanel savePanel = this.diagramWindowManager.getCurrentSavePanel(this.parentComponent);
        int selectedIndex = this.diagramWindowManager.getSavePanelIndex(this.parentComponent);
        String currentTabText = this.diagramWindowManager.getSavePanelTitle(selectedIndex);
        if (selectedIndex > -1) {
            this.saveDiagramAs.setText("Save As (" + currentTabText + ")");
            this.saveDiagramAs.setActionCommand(Integer.toString(selectedIndex));
            this.saveDiagram.setText("Save (" + currentTabText + ")");
            this.saveDiagram.setActionCommand(Integer.toString(selectedIndex));
            this.closeTabMenuItem.setText("Close (" + currentTabText + ")");
            this.closeTabMenuItem.setActionCommand(Integer.toString(selectedIndex));
            this.saveAsGlobalDefaultMenuItem.setText("Set Global Default Diagram as (" + currentTabText + ")");
            this.saveAsGlobalDefaultMenuItem.setActionCommand(Integer.toString(selectedIndex));
            this.saveAsProjectDefaultMenuItem.setText("Set Project Default Diagram as (" + currentTabText + ")");
            this.saveAsProjectDefaultMenuItem.setActionCommand(Integer.toString(selectedIndex));
        }
        if (savePanel != null) {
            this.saveDiagram.setEnabled(savePanel.hasSaveFileName() && savePanel.requiresSave());
            this.saveDiagramAs.setEnabled(true);
            this.exportToR.setEnabled(true);
            this.closeTabMenuItem.setEnabled(true);
            this.saveAsGlobalDefaultMenuItem.setEnabled(true);
            this.saveAsProjectDefaultMenuItem.setEnabled(true);
            this.savePdfMenuItem.setEnabled(true);
        } else {
            this.saveDiagramAs.setEnabled(false);
            this.saveDiagram.setEnabled(false);
            this.exportToR.setEnabled(false);
            this.closeTabMenuItem.setEnabled(false);
            this.saveAsGlobalDefaultMenuItem.setEnabled(true);
            this.saveAsProjectDefaultMenuItem.setEnabled(true);
            this.savePdfMenuItem.setEnabled(false);
        }
    }

    private void closeTabMenuItemActionPerformed(ActionEvent evt) {
        String diagramTitle;
        int tabIndex = Integer.valueOf(evt.getActionCommand());
        SavePanel savePanel = this.diagramWindowManager.getSavePanel(tabIndex);
        boolean userCanceled = this.diagramWindowManager.offerUserToSave(savePanel, diagramTitle = this.diagramWindowManager.getSavePanelTitle(tabIndex));
        if (!userCanceled) {
            this.diagramWindowManager.closeSavePanel(tabIndex);
        }
    }

    private void newDiagramMenuItemActionPerformed(ActionEvent evt) {
        Dimension parentSize = this.parentComponent.getSize();
        Point parentLocation = this.parentComponent.getLocation();
        int offset = 10;
        try {
            this.diagramWindowManager.newDiagram(new Rectangle(parentLocation.x + offset, parentLocation.y + offset, parentSize.width - offset, parentSize.height - offset), null);
        }
        catch (EntityServiceException entityServiceException) {
            this.dialogHandler.addMessageDialogToQueue("Failed to create a new diagram: " + entityServiceException.getMessage(), "Open Diagram Error");
        }
    }

    private void importGedcomFileActionPerformed(ActionEvent evt) {
        HashMap<String, 15> fileFilterMap = new HashMap<String, 15>(2);
        fileFilterMap.put("importfiles", new FileFilter(){

            public boolean accept(File selectedFile) {
                if (selectedFile.isDirectory()) {
                    return true;
                }
                String currentFileName = selectedFile.getName().toLowerCase();
                if (currentFileName.endsWith(".gedcom")) {
                    return true;
                }
                if (currentFileName.endsWith(".ged")) {
                    return true;
                }
                if (currentFileName.endsWith(".txt")) {
                    return true;
                }
                if (currentFileName.endsWith(".csv")) {
                    return true;
                }
                if (currentFileName.endsWith(".tip")) {
                    return true;
                }
                return currentFileName.endsWith(".kinoath");
            }

            public String getDescription() {
                return "GEDCOM, CSV, TIP Kinship Data";
            }
        });
        File[] importFiles = this.dialogHandler.showFileSelectBox("Import Kinship Data", false, true, fileFilterMap, PluginDialogHandler.DialogueType.open, null);
        if (importFiles != null) {
            if (importFiles.length == 0) {
                this.dialogHandler.addMessageDialogToQueue("No files selected for import", "Import Kinship Data");
            } else {
                SavePanel currentSavePanel = this.diagramWindowManager.getCurrentSavePanel(this.parentComponent);
                if (currentSavePanel instanceof KinDiagramPanel) {
                    KinDiagramPanel diagramPanel = (KinDiagramPanel)currentSavePanel;
                    for (File importFile : importFiles) {
                        try {
                            this.diagramWindowManager.openImportPanel(importFile, diagramPanel, this.getEntityCollection());
                        }
                        catch (ImportException exception1) {
                            this.dialogHandler.addMessageDialogToQueue(exception1.getMessage() + "\n" + importFile.getAbsolutePath(), "Import File");
                        }
                    }
                }
            }
        }
    }

    private void importCsvFileActionPerformed(ActionEvent evt) {
        this.importGedcomFileActionPerformed(evt);
    }

    private void importGedcomUrlActionPerformed(ActionEvent evt) {
        String[] importList;
        for (String importUrlString : importList = new String[]{"http://gedcomlibrary.com/gedcoms.html", "http://GedcomLibrary.com/gedcoms/gl120365.ged", "http://GedcomLibrary.com/gedcoms/gl120366.ged", "http://GedcomLibrary.com/gedcoms/gl120367.ged", "http://GedcomLibrary.com/gedcoms/gl120368.ged", "http://GedcomLibrary.com/gedcoms/gl120369.ged", "http://GedcomLibrary.com/gedcoms/gl120370.ged", "http://GedcomLibrary.com/gedcoms/gl120371.ged", "http://GedcomLibrary.com/gedcoms/gl120372.ged", "http://GedcomLibrary.com/gedcoms/liverpool.ged", "http://GedcomLibrary.com/gedcoms/misc2a.ged", "http://GedcomLibrary.com/gedcoms/myline.ged", "http://gedcomlibrary.com/gedcoms/gl120368.ged", "http://GedcomLibrary.com/gedcoms/gl120367.ged", "http://GedcomLibrary.com/gedcoms/liverpool.ged", "http://GedcomLibrary.com/gedcoms/misc2a.ged", "http://GedcomLibrary.com/gedcoms/gl120372.ged"}) {
            SavePanel currentSavePanel = this.diagramWindowManager.getCurrentSavePanel(this.parentComponent);
            if (!(currentSavePanel instanceof KinDiagramPanel)) continue;
            KinDiagramPanel diagramPanel = (KinDiagramPanel)currentSavePanel;
            try {
                this.diagramWindowManager.openImportPanel(importUrlString, diagramPanel, this.getEntityCollection());
            }
            catch (ImportException exception1) {
                this.dialogHandler.addMessageDialogToQueue(exception1.getMessage() + "\n" + importUrlString, "Import File");
            }
        }
    }

    private void savePdfMenuItemActionPerformed(ActionEvent evt) {
        DiagramTranscoder diagramTranscoder = new DiagramTranscoder(this.diagramWindowManager.getCurrentSavePanel(this.parentComponent));
        DiagramTranscoderPanel diagramTranscoderPanel = new DiagramTranscoderPanel(diagramTranscoder);
        File[] selectedFilesArray = this.dialogHandler.showFileSelectBox("Export as PDF/JPEG/PNG/TIFF", false, false, null, PluginDialogHandler.DialogueType.save, (JComponent)diagramTranscoderPanel);
        if (selectedFilesArray != null) {
            try {
                for (File selectedFile : selectedFilesArray) {
                    diagramTranscoder.exportDiagram(selectedFile);
                }
            }
            catch (TranscoderException exception) {
                this.dialogHandler.addMessageDialogToQueue(exception.getMessage() + "\nThis may occur when using the webstart version.", "Export Image Error");
                BugCatcherManager.getBugCatcher().logError((Exception)((Object)exception));
            }
            catch (IOException exception) {
                this.dialogHandler.addMessageDialogToQueue(exception.getMessage(), "Export Image Error");
                BugCatcherManager.getBugCatcher().logError((Exception)exception);
            }
        }
    }

    private void exportToRActionPerformed(ActionEvent evt) {
        SavePanel currentSavePanel = this.diagramWindowManager.getCurrentSavePanel(this.parentComponent);
        HashMap<String, 16> fileFilterMap = new HashMap<String, 16>(2);
        for (final String[] currentType : new String[][]{{"Data Frame Tab-separated Values", ".tab"}}) {
            fileFilterMap.put(currentType[0], new FileFilter(){

                public boolean accept(File selectedFile) {
                    String extensionLowerCase = currentType[1].toLowerCase();
                    return selectedFile.exists() && (selectedFile.isDirectory() || selectedFile.getName().toLowerCase().endsWith(extensionLowerCase));
                }

                public String getDescription() {
                    return currentType[0];
                }
            });
        }
        File[] selectedFilesArray = this.dialogHandler.showFileSelectBox("Export Tab-separated Values", false, false, fileFilterMap, PluginDialogHandler.DialogueType.save, null);
        if (selectedFilesArray != null) {
            for (File selectedFile : selectedFilesArray) {
                if (!selectedFile.getName().toLowerCase().endsWith(".tab")) {
                    selectedFile = new File(selectedFile.getParentFile(), selectedFile.getName() + ".tab");
                }
                new ExportToR(this.sessionStorage, this.dialogHandler).doExport(this, currentSavePanel, selectedFile);
            }
        }
    }

    private void entityUploadMenuItemActionPerformed(ActionEvent evt) {
        this.diagramWindowManager.openEntityUploadPanel(null, this.getEntityCollection());
    }

    private void saveAsDefaultMenuItemActionPerformed(ActionEvent evt, boolean saveAsGlobal) {
        int tabIndex = Integer.valueOf(evt.getActionCommand());
        SavePanel savePanel = this.diagramWindowManager.getSavePanel(tabIndex);
        if (saveAsGlobal) {
            savePanel.saveToFile(KinDiagramPanel.getGlobalDefaultDiagramFile(this.sessionStorage));
        } else {
            savePanel.saveToFile(KinDiagramPanel.getDefaultDiagramFile(savePanel.getGraphPanel().dataStoreSvg.projectRecord));
        }
    }

    private EntityCollection getEntityCollection() {
        SavePanel currentSavePanel = this.diagramWindowManager.getCurrentSavePanel(this.parentComponent);
        if (currentSavePanel instanceof KinDiagramPanel) {
            KinDiagramPanel diagramPanel = (KinDiagramPanel)currentSavePanel;
            return diagramPanel.getEntityCollection();
        }
        throw new UnsupportedOperationException("Cannot perform this menu action on this type of window");
    }
}

