/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.ui.menu;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.filechooser.FileFilter;
import javax.xml.bind.JAXBException;
import nl.mpi.arbil.util.BugCatcherManager;
import nl.mpi.arbil.util.MessageDialogHandler;
import nl.mpi.flap.plugin.PluginDialogHandler;
import nl.mpi.kinnate.entityindexer.EntityServiceException;
import nl.mpi.kinnate.projects.ProjectManager;
import nl.mpi.kinnate.projects.ProjectRecord;
import nl.mpi.kinnate.ui.ProjectPreviewPanel;
import nl.mpi.kinnate.ui.window.AbstractDiagramManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectFileMenu
extends JMenu
implements ActionListener {
    private final AbstractDiagramManager diagramWindowManager;
    private final Component parentComponent;
    private final MessageDialogHandler dialogHandler;
    private final ProjectManager projectManager;

    public ProjectFileMenu(AbstractDiagramManager diagramWindowManager, Component parentComponent, MessageDialogHandler dialogHandler, ProjectManager projectManager) {
        this.diagramWindowManager = diagramWindowManager;
        this.parentComponent = parentComponent;
        this.dialogHandler = dialogHandler;
        this.projectManager = projectManager;
        this.setText("Open Recent Project");
        this.addMenuListener(new MenuListener(){

            public void menuCanceled(MenuEvent evt) {
            }

            public void menuDeselected(MenuEvent evt) {
            }

            public void menuSelected(MenuEvent evt) {
                ProjectFileMenu.this.setupMenu();
            }
        });
    }

    private void setupMenu() {
        this.removeAll();
        try {
            for (ProjectRecord projectRecord : this.projectManager.getRecentProjectsList().getProjectRecords()) {
                JMenuItem currentMenuItem = new JMenuItem(projectRecord.getProjectName());
                currentMenuItem.setToolTipText(projectRecord.getProjectDirectory().getAbsolutePath());
                currentMenuItem.setActionCommand(projectRecord.getProjectDirectory().getAbsolutePath());
                currentMenuItem.addActionListener(this);
                this.add(currentMenuItem);
            }
            this.add(new JSeparator());
            JMenuItem clearMenuItem = new JMenuItem("Clear List");
            clearMenuItem.setActionCommand("Clear List");
            clearMenuItem.addActionListener(this);
            this.add(clearMenuItem);
        }
        catch (JAXBException exception) {
            JMenuItem currentMenuItem = new JMenuItem("<recent projects could not be found>");
            currentMenuItem.setEnabled(false);
            this.add(currentMenuItem);
        }
    }

    private HashMap<String, FileFilter> getProjectFileFilter() {
        HashMap<String, FileFilter> fileFilterMap = new HashMap<String, FileFilter>(2);
        for (final String[] currentType : new String[][]{{"KinOath Project", "kinoath.proj"}}) {
            fileFilterMap.put(currentType[0], new FileFilter(){

                public boolean accept(File selectedFile) {
                    try {
                        ProjectRecord projectRecord = ProjectFileMenu.this.projectManager.loadProjectRecord(selectedFile);
                        return projectRecord != null;
                    }
                    catch (JAXBException exception) {
                        return false;
                    }
                }

                public String getDescription() {
                    return currentType[0];
                }
            });
        }
        return fileFilterMap;
    }

    private void openProject(ProjectRecord projectRecord) {
        Dimension parentSize = this.parentComponent.getSize();
        Point parentLocation = this.parentComponent.getLocation();
        int offset = 10;
        try {
            this.diagramWindowManager.newDiagram(new Rectangle(parentLocation.x + offset, parentLocation.y + offset, parentSize.width - offset, parentSize.height - offset), projectRecord);
        }
        catch (EntityServiceException entityServiceException) {
            this.dialogHandler.addMessageDialogToQueue("Failed to create a new diagram: " + entityServiceException.getMessage(), "Open Diagram Error");
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if ("new".equals(e.getActionCommand())) {
            File[] selectedFilesArray = this.dialogHandler.showFileSelectBox("New Project", true, false, this.getProjectFileFilter(), PluginDialogHandler.DialogueType.save, null);
            if (selectedFilesArray != null) {
                File selecteFile = selectedFilesArray[0];
                System.out.println(selecteFile.getAbsolutePath());
                if (selecteFile.exists()) {
                    this.dialogHandler.addMessageDialogToQueue("The selected file already exists, please enter a unique name.", "Create Project");
                } else {
                    ProjectRecord projectRecord = new ProjectRecord(selecteFile, selecteFile.getName());
                    try {
                        selecteFile.mkdir();
                        this.projectManager.saveProjectRecord(projectRecord, true, true);
                        this.openProject(projectRecord);
                    }
                    catch (JAXBException exception) {
                        this.dialogHandler.addMessageDialogToQueue(exception.getMessage(), "Create Project Error");
                    }
                }
            }
        } else if ("browse".equals(e.getActionCommand())) {
            ProjectPreviewPanel previewPanel = new ProjectPreviewPanel(this.projectManager, false);
            File[] selectedFilesArray = this.dialogHandler.showFileSelectBox("Open Project", false, false, this.getProjectFileFilter(), PluginDialogHandler.DialogueType.open, (JComponent)previewPanel);
            if (selectedFilesArray != null) {
                System.out.println(selectedFilesArray[0].getAbsolutePath());
                try {
                    this.openProject(this.projectManager.loadProjectRecord(selectedFilesArray[0]));
                }
                catch (JAXBException exception) {
                    this.dialogHandler.addMessageDialogToQueue(exception.getMessage(), "Read Project Record Error");
                }
            }
        } else if ("Clear List".equals(e.getActionCommand())) {
            try {
                this.projectManager.clearRecentProjectsList();
            }
            catch (JAXBException exception) {
                BugCatcherManager.getBugCatcher().logError((Exception)((Object)exception));
            }
        } else {
            try {
                String actionString = e.getActionCommand();
                File recentProjectFile = new File(actionString);
                ProjectRecord selectedProjectRecord = this.projectManager.loadProjectRecord(recentProjectFile);
                this.openProject(selectedProjectRecord);
            }
            catch (JAXBException exception) {
                this.dialogHandler.addMessageDialogToQueue("Failed to open project: " + exception.getMessage(), "Open Project Error");
            }
        }
    }
}

