/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.basex.core.AProp;
import org.basex.core.Prop;
import org.basex.io.IOFile;

public final class MainProp
extends AProp {
    private static final boolean USERHOME = Prop.HOME.equals(Prop.USERHOME);
    public static final Object[] DBPATH = new Object[]{"DBPATH", Prop.HOME + (USERHOME ? "BaseXData" : "data")};
    public static final Object[] HTTPPATH = new Object[]{"HTTPPATH", Prop.HOME + (USERHOME ? "BaseXHTTP" : "http")};
    public static final Object[] REPOPATH = new Object[]{"REPOPATH", Prop.HOME + (USERHOME ? "BaseXRepo" : "repo")};
    public static final Object[] LANG = new Object[]{"LANG", Prop.language};
    public static final Object[] LANGKEYS = new Object[]{"LANGKEYS", false};
    public static final Object[] HOST = new Object[]{"HOST", "localhost"};
    public static final Object[] PORT = new Object[]{"PORT", 1984};
    public static final Object[] SERVERHOST = new Object[]{"SERVERHOST", ""};
    public static final Object[] SERVERPORT = new Object[]{"SERVERPORT", 1984};
    public static final Object[] EVENTPORT = new Object[]{"EVENTPORT", 1985};
    public static final Object[] HTTPPORT = new Object[]{"HTTPPORT", 8984};
    public static final Object[] STOPPORT = new Object[]{"STOPPORT", 8985};
    public static final Object[] PROXYHOST = new Object[]{"PROXYHOST", ""};
    public static final Object[] PROXYPORT = new Object[]{"PROXYPORT", 80};
    public static final Object[] NONPROXYHOSTS = new Object[]{"NONPROXYHOSTS", ""};
    public static final Object[] TIMEOUT = new Object[]{"TIMEOUT", 30};
    public static final Object[] KEEPALIVE = new Object[]{"KEEPALIVE", 600};
    public static final Object[] DEBUG = new Object[]{"DEBUG", false};
    public static final Object[] PARALLEL = new Object[]{"PARALLEL", 8};
    public static final Object[] DBLOCKING = new Object[]{"DBLOCKING", false};

    MainProp() {
        this.read("");
        this.finish();
    }

    MainProp(HashMap<String, String> map) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            this.set(entry.getKey(), entry.getValue());
        }
        this.finish();
    }

    public IOFile dbpath(String db) {
        return new IOFile(this.get(DBPATH), db);
    }

    public String random(String db) {
        String nm;
        while (this.dbpath(nm = db + '_' + new Random().nextInt(Integer.MAX_VALUE)).exists()) {
        }
        return nm;
    }

    public IOFile dbpath() {
        return new IOFile(this.get(DBPATH));
    }

    public boolean dbexists(String db) {
        return !db.isEmpty() && this.dbpath(db).exists();
    }

    @Override
    protected void finish() {
        Prop.language = this.get(LANG);
        Prop.langkeys = this.is(LANGKEYS);
        Prop.debug = this.is(DEBUG);
        String ph = this.get(PROXYHOST);
        String pp = Integer.toString(this.num(PROXYPORT));
        System.setProperty("http.proxyHost", ph);
        System.setProperty("http.proxyPort", pp);
        System.setProperty("https.proxyHost", ph);
        System.setProperty("https.proxyPort", pp);
        System.setProperty("http.nonProxyHosts", this.get(NONPROXYHOSTS));
    }
}

