/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.serial;

import org.basex.core.AProp;
import org.basex.core.Prop;
import org.basex.io.serial.SerializerException;
import org.basex.query.util.Err;
import org.basex.util.TokenBuilder;

public final class SerializerProp
extends AProp {
    public static final Object[] S_BYTE_ORDER_MARK = new Object[]{"byte-order-mark", "no"};
    public static final Object[] S_CDATA_SECTION_ELEMENTS = new Object[]{"cdata-section-elements", ""};
    public static final Object[] S_DOCTYPE_PUBLIC = new Object[]{"doctype-public", ""};
    public static final Object[] S_DOCTYPE_SYSTEM = new Object[]{"doctype-system", ""};
    public static final Object[] S_ENCODING = new Object[]{"encoding", "UTF-8"};
    public static final Object[] S_ESCAPE_URI_ATTRIBUTES = new Object[]{"escape-uri-attributes", "no"};
    public static final Object[] S_INCLUDE_CONTENT_TYPE = new Object[]{"include-content-type", "no"};
    public static final Object[] S_INDENT = new Object[]{"indent", "yes"};
    public static final Object[] S_SUPPRESS_INDENTATION = new Object[]{"suppress-indentation", ""};
    public static final Object[] S_MEDIA_TYPE = new Object[]{"media-type", ""};
    public static final Object[] S_METHOD = new Object[]{"method", "xml"};
    public static final Object[] S_NORMALIZATION_FORM = new Object[]{"normalization-form", "NFC"};
    public static final Object[] S_OMIT_XML_DECLARATION = new Object[]{"omit-xml-declaration", "yes"};
    public static final Object[] S_STANDALONE = new Object[]{"standalone", "omit"};
    public static final Object[] S_UNDECLARE_PREFIXES = new Object[]{"undeclare-prefixes", "no"};
    public static final Object[] S_USE_CHARACTER_MAPS = new Object[]{"use-character-maps", ""};
    public static final Object[] S_VERSION = new Object[]{"version", ""};
    public static final Object[] S_NEWLINE = new Object[]{"newline", Prop.NL.equals("\r") ? "\\r" : (Prop.NL.equals("\n") ? "\\n" : "\\r\\n")};
    public static final Object[] S_FORMAT = new Object[]{"format", "yes"};
    public static final Object[] S_TABULATOR = new Object[]{"tabulator", "no"};
    public static final Object[] S_INDENTS = new Object[]{"indents", "2"};
    public static final Object[] S_SEPARATOR = new Object[]{"separator", " "};
    public static final Object[] S_WRAP_PREFIX = new Object[]{"wrap-prefix", ""};
    public static final Object[] S_WRAP_URI = new Object[]{"wrap-uri", ""};
    public static final Object[] S_TEMPLATE = new Object[]{"template", ""};

    public SerializerProp() {
    }

    public SerializerProp(String s) {
        for (String ser : s.trim().split(",")) {
            if (ser.isEmpty()) continue;
            String[] sprop = ser.split("=", 2);
            this.set(sprop[0].trim(), sprop.length < 2 ? "" : sprop[1].trim());
        }
    }

    public String check(Object[] key, String ... allowed) throws SerializerException {
        String val = this.get(key);
        for (String a : allowed) {
            if (!a.equals(val)) continue;
            return val;
        }
        throw SerializerProp.error(key[0], val, allowed);
    }

    public boolean yes(Object[] key) throws SerializerException {
        String val = this.get(key);
        for (String a : new String[]{"yes", "true", "ON"}) {
            if (!a.equals(val)) continue;
            return true;
        }
        for (String a : new String[]{"no", "false", "OFF"}) {
            if (!a.equals(val)) continue;
            return false;
        }
        throw SerializerProp.error(key[0], val, "yes", "no");
    }

    public static SerializerException error(Object key, String found, String ... allowed) throws SerializerException {
        TokenBuilder tb = new TokenBuilder();
        tb.addExt("Parameter '%' must be [%", key, allowed[0]);
        for (int a = 1; a < allowed.length; ++a) {
            tb.addExt("|%", allowed[a]);
        }
        tb.addExt("]; '%' found", found);
        throw Err.SERANY.thrwSerial(tb);
    }
}

