/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Arr;
import org.basex.query.expr.Expr;
import org.basex.query.iter.Iter;
import org.basex.query.iter.ValueBuilder;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.IntSeq;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.SeqType;
import org.basex.util.InputInfo;
import org.basex.util.TokenBuilder;

public final class List
extends Arr {
    public List(InputInfo ii, Expr ... l) {
        super(ii, l);
    }

    @Override
    public void checkUp() throws QueryException {
        this.checkAllUp(this.expr);
    }

    @Override
    public Expr compile(QueryContext ctx) throws QueryException {
        for (int e = 0; e < this.expr.length; ++e) {
            this.expr[e] = this.expr[e].compile(ctx);
        }
        this.size = 0L;
        for (Expr e : this.expr) {
            long c = e.size();
            if (c == -1L) {
                this.size = c;
                break;
            }
            this.size += c;
        }
        this.type = SeqType.EMP;
        boolean v = true;
        for (Expr e : this.expr) {
            v &= e.isValue();
            if (e.isEmpty()) continue;
            SeqType et = e.type();
            this.type = this.type == SeqType.EMP ? et : SeqType.get(et.type == this.type.type ? et.type : AtomType.ITEM, et.mayBeZero() && this.type.mayBeZero() ? SeqType.Occ.ZERO_MORE : SeqType.Occ.ONE_MORE);
        }
        return v ? (this.type.type.instanceOf(AtomType.ITR) ? this.optPre(IntSeq.get(this.expr, this.size, this.type.type), ctx) : this.optPre(this.value(ctx), ctx)) : this;
    }

    @Override
    public Iter iter(final QueryContext ctx) {
        return new Iter(){
            Iter ir;
            int e;

            @Override
            public Item next() throws QueryException {
                while (true) {
                    Item it;
                    if (this.ir == null) {
                        if (this.e == List.this.expr.length) {
                            return null;
                        }
                        this.ir = ctx.iter(List.this.expr[this.e++]);
                    }
                    if ((it = this.ir.next()) != null) {
                        return it;
                    }
                    this.ir = null;
                }
            }
        };
    }

    @Override
    public Value value(QueryContext ctx) throws QueryException {
        ValueBuilder vb = new ValueBuilder();
        for (Expr e : this.expr) {
            vb.add(ctx.value(e));
        }
        return vb.value();
    }

    @Override
    public boolean isVacuous() {
        for (Expr e : this.expr) {
            if (e.isVacuous()) continue;
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return new TokenBuilder("(").addSep(this.expr, ", ").add(")").toString();
    }
}

