/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryModule;
import org.basex.query.QueryText;
import org.basex.query.expr.Expr;
import org.basex.query.func.JavaMapping;
import org.basex.query.util.Err;
import org.basex.query.value.Value;
import org.basex.query.value.node.FElem;
import org.basex.util.InputInfo;
import org.basex.util.TokenBuilder;

public final class JavaModuleFunc
extends JavaMapping {
    private final Object module;
    private final Method mth;

    JavaModuleFunc(InputInfo ii, Object jm, Method m, Expr[] a) {
        super(ii, a);
        this.module = jm;
        this.mth = m;
    }

    @Override
    protected Object eval(Value[] args, QueryContext ctx) throws QueryException {
        if (this.module instanceof QueryModule) {
            ((QueryModule)this.module).context = ctx;
        }
        try {
            try {
                return this.mth.invoke(this.module, (Object[])args);
            }
            catch (IllegalArgumentException iae) {
                Object[] ar = new Object[args.length];
                for (int a = 0; a < args.length; ++a) {
                    ar[a] = args[a].toJava();
                }
                return this.mth.invoke(this.module, ar);
            }
        }
        catch (InvocationTargetException ex) {
            Throwable cause = ex.getCause();
            throw cause instanceof QueryException ? ((QueryException)cause).info(this.info) : Err.JAVAERR.thrw(this.info, cause);
        }
        catch (Throwable ex) {
            TokenBuilder expect = new TokenBuilder();
            for (Class<?> c : this.mth.getParameterTypes()) {
                if (!expect.isEmpty()) {
                    expect.add(", ");
                }
                expect.add(c.getSimpleName());
            }
            throw Err.JAVAMOD.thrw(this.info, this.mth.getName() + '(' + expect + ')', this.mth.getName() + '(' + JavaModuleFunc.foundArgs(args) + ')');
        }
    }

    @Override
    public void plan(FElem plan) {
        this.addPlan(plan, this.planElem(QueryText.NAM, this.name()), this.expr);
    }

    @Override
    public String description() {
        return this.name() + " method";
    }

    private String name() {
        return this.module.getClass().getSimpleName() + ':' + this.mth.getName();
    }

    @Override
    public String toString() {
        return this.name() + "(" + this.toString(", ") + ")";
    }

    @Override
    public boolean uses(Expr.Use u) {
        return u == Expr.Use.NDT && this.mth.getAnnotation(QueryModule.Deterministic.class) == null || (u == Expr.Use.CTX || u == Expr.Use.POS) && this.mth.getAnnotation(QueryModule.FocusDependent.class) == null || super.uses(u);
    }
}

