/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.type;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.util.Err;
import org.basex.query.value.item.FItem;
import org.basex.query.value.item.Item;
import org.basex.query.value.map.Map;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.FuncType;
import org.basex.query.value.type.SeqType;
import org.basex.util.InputInfo;

public final class MapType
extends FuncType {
    public final AtomType keyType;

    MapType(AtomType arg, SeqType rt) {
        super(new SeqType[]{arg.seqType()}, rt);
        this.keyType = arg;
    }

    @Override
    public byte[] string() {
        return QueryText.MAP;
    }

    @Override
    public boolean isMap() {
        return true;
    }

    @Override
    public FItem cast(Item it, QueryContext ctx, InputInfo ii) throws QueryException {
        if (!it.type.isMap() || !((Map)it).hasType(this)) {
            Err.cast(ii, this, it);
        }
        return (Map)it;
    }

    public static MapType get(AtomType key, SeqType val) {
        return key == AtomType.AAT && val.eq(SeqType.ITEM_ZM) ? SeqType.ANY_MAP : new MapType(key, val);
    }

    @Override
    public String toString() {
        return this.keyType == AtomType.AAT && this.ret.eq(SeqType.ITEM_ZM) ? "map(*)" : "map(" + this.keyType + ", " + this.ret + ')';
    }
}

