/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.imdi.api;

import javax.xml.transform.TransformerException;
import nl.mpi.imdi.api.IMDIEdit;
import nl.mpi.imdi.api.IMDILink;
import nl.mpi.imdi.api.IMDIXMLFormat;
import nl.mpi.util.OurURL;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class CreateLinks {
    protected static IMDILink createCorpusLink(Document doc, IMDILink link, IMDIEdit iedit) {
        String linkName = link.getLinkName();
        OurURL curl = link.getRawURL();
        String urid = link.getURID();
        String urlToLink = link.getLinkDefinition();
        IMDILink result = null;
        Element root = doc.getDocumentElement();
        Element target = IMDIXMLFormat.selectElement(root, 2);
        Element el = null;
        try {
            el = doc.createElementNS("http://www.mpi.nl/IMDI/Schema/IMDI", IMDIXMLFormat.getElementName(2));
            el.setAttribute("Name", linkName);
            if (urid != null) {
                el.setAttribute("ArchiveHandle", urid);
            }
            Text txt = doc.createTextNode(urlToLink);
            el.appendChild(txt);
            target.appendChild(el);
        }
        catch (DOMException de) {
            iedit.SEPe("DOMException while creating CorpusLink: " + de.getMessage());
            return null;
        }
        IMDIXMLFormat.addDomIds(doc, el);
        result = new IMDILink(IMDIXMLFormat.generateSpecFromNode(el), IMDIXMLFormat.getDomId(el), 2, curl);
        result.setLinkName(linkName);
        result.setLinkDefinition(urlToLink);
        result.setURID(urid);
        return result;
    }

    protected static IMDILink createLexiconResource(Document doc, IMDILink link, IMDIEdit iedit) {
        OurURL curl = link.getRawURL();
        String urlToLink = link.getLinkDefinition();
        String urid = link.getURID();
        try {
            Document dtemp = IMDIXMLFormat.loadTemplate(1);
            if (dtemp == null) {
                return null;
            }
            Element roottemp = dtemp.getDocumentElement();
            Element mftemp = IMDIXMLFormat.selectElement(roottemp, 7);
            if (mftemp == null) {
                return null;
            }
            Text linktemp = dtemp.createTextNode(urlToLink);
            Node restemp = IMDIXMLFormat.selectLink(mftemp, 7);
            if (restemp == null || !(restemp instanceof Element)) {
                iedit.SEPe("Template error: No LexiconResource!");
                return null;
            }
            Element resElem = (Element)restemp;
            if (urid != null) {
                resElem.setAttribute("ArchiveHandle", urid);
            }
            resElem.appendChild(linktemp);
            mftemp.replaceChild(resElem, mftemp.getFirstChild());
            mftemp.removeChild(mftemp.getFirstChild().getNextSibling());
            Element root = doc.getDocumentElement();
            Element res = IMDIXMLFormat.selectResources(root);
            Node nodeToMove = doc.importNode(mftemp, true);
            Element wr = IMDIXMLFormat.selectElement(root, 7);
            if (wr != null) {
                res.insertBefore(nodeToMove, wr);
            } else {
                Node nonMF = XPathAPI.selectSingleNode((Node)res, (String)"*[name()!='WrittenResource' and name()!='MediaFile']");
                res.insertBefore(nodeToMove, nonMF);
            }
            IMDIXMLFormat.addDomIds(doc, nodeToMove);
            String domId = IMDIXMLFormat.getDomId(nodeToMove);
            if (domId != null) {
                IMDILink result = new IMDILink(IMDIXMLFormat.generateSpecFromNode(nodeToMove), domId, 4, curl);
                result.setURID(urid);
                result.setLinkDefinition(urlToLink);
                return result;
            }
            iedit.SEPi("createLexiconResource: No target ResourceLink element (domId)");
        }
        catch (TransformerException te) {
            iedit.SEPe("TransformerException while adding Lexicon Resource: " + te.getMessage());
        }
        catch (DOMException de) {
            iedit.SEPe("DOMException while adding Lexicon Resource: " + de.getMessage());
        }
        return null;
    }

    protected static IMDILink createWrittenResource(Document doc, IMDILink link, IMDIEdit iedit) {
        OurURL curl = link.getRawURL();
        String urlToLink = link.getLinkDefinition();
        String urid = link.getURID();
        try {
            Document dtemp = IMDIXMLFormat.loadTemplate(1);
            if (dtemp == null) {
                return null;
            }
            Element roottemp = dtemp.getDocumentElement();
            Element mftemp = IMDIXMLFormat.selectElement(roottemp, 4);
            if (mftemp == null) {
                return null;
            }
            Text linktemp = dtemp.createTextNode(urlToLink);
            Node restemp = IMDIXMLFormat.selectLink(mftemp, 4);
            if (restemp == null || !(restemp instanceof Element)) {
                iedit.SEPe("Template error: No WrittenResource!");
                return null;
            }
            Element resElem = (Element)restemp;
            if (urid != null) {
                resElem.setAttribute("ArchiveHandle", urid);
            }
            resElem.appendChild(linktemp);
            mftemp.replaceChild(resElem, mftemp.getFirstChild());
            mftemp.removeChild(mftemp.getFirstChild().getNextSibling());
            Element root = doc.getDocumentElement();
            Element res = IMDIXMLFormat.selectResources(root);
            Node nodeToMove = doc.importNode(mftemp, true);
            Element wr = IMDIXMLFormat.selectElement(root, 4);
            if (wr != null) {
                res.insertBefore(nodeToMove, wr);
            } else {
                Node nonMF = XPathAPI.selectSingleNode((Node)res, (String)"*[name()!='MediaFile']");
                res.insertBefore(nodeToMove, nonMF);
            }
            IMDIXMLFormat.addDomIds(doc, nodeToMove);
            String domId = IMDIXMLFormat.getDomId(nodeToMove);
            if (domId != null) {
                IMDILink result = new IMDILink(IMDIXMLFormat.generateSpecFromNode(nodeToMove), domId, 4, curl);
                result.setURID(urid);
                result.setLinkDefinition(urlToLink);
                return result;
            }
            iedit.SEPi("createWrittenResource: No target ResourceLink element (domId)");
        }
        catch (TransformerException te) {
            iedit.SEPe("TransformerException while adding Written Resource: " + te.getMessage());
        }
        catch (DOMException de) {
            iedit.SEPe("DOMException while adding Written Resource: " + de.getMessage());
        }
        return null;
    }

    protected static IMDILink createMediaFile(Document doc, IMDILink link, IMDIEdit iedit) {
        OurURL curl = link.getRawURL();
        String urid = link.getURID();
        String urlToLink = link.getLinkDefinition();
        try {
            Document dtemp = IMDIXMLFormat.loadTemplate(1);
            if (dtemp == null) {
                return null;
            }
            Element roottemp = dtemp.getDocumentElement();
            Element mftemp = IMDIXMLFormat.selectElement(roottemp, 5);
            if (mftemp == null) {
                return null;
            }
            Text linktemp = dtemp.createTextNode(urlToLink);
            Node restemp = IMDIXMLFormat.selectLink(mftemp, 5);
            if (restemp == null || !(restemp instanceof Element)) {
                iedit.SEPe("Template error: No MediaFile!");
                return null;
            }
            Element resElem = (Element)restemp;
            if (urid != null) {
                resElem.setAttribute("ArchiveHandle", urid);
            }
            resElem.appendChild(linktemp);
            mftemp.replaceChild(resElem, mftemp.getFirstChild());
            Element root = doc.getDocumentElement();
            Element res = IMDIXMLFormat.selectResources(root);
            if (res == null) {
                return null;
            }
            Node nodeToMove = doc.importNode(mftemp, true);
            res.insertBefore(nodeToMove, res.getFirstChild());
            IMDIXMLFormat.addDomIds(doc, nodeToMove);
            String domId = IMDIXMLFormat.getDomId(nodeToMove);
            if (domId != null) {
                IMDILink result = new IMDILink(IMDIXMLFormat.generateSpecFromNode(nodeToMove), domId, 5, curl);
                result.setURID(urid);
                result.setLinkDefinition(urlToLink);
                return result;
            }
            iedit.SEPi("createMediaFile: No target ResourceLink element (domId)");
        }
        catch (DOMException de) {
            iedit.SEPe("DOMException while adding Media File: " + de.getMessage());
        }
        return null;
    }

    protected static IMDILink createInfoFile(Document doc, IMDILink target, IMDIEdit iedit) {
        OurURL curl = target.getRawURL();
        String urid = target.getURID();
        String urlToLink = target.getLinkDefinition();
        String descText = target.getValue();
        String spec = target.getSpec();
        String langId = target.getLanguageId();
        if (langId == null) {
            return null;
        }
        try {
            Element root = doc.getDocumentElement();
            String parentDescSpec = spec;
            spec = spec + "." + IMDIXMLFormat.getElementName(3);
            String query = IMDIXMLFormat.spec2XPath(spec);
            if (query == null) {
                return null;
            }
            if (IMDIXMLFormat.pointsToAttribute(query)) {
                iedit.SEPi("Spec does not point to a valid location to add an Info File: " + spec);
                return null;
            }
            Element newDesc = doc.createElementNS("http://www.mpi.nl/IMDI/Schema/IMDI", IMDIXMLFormat.getElementName(3));
            Text txtNode = doc.createTextNode(descText);
            newDesc.appendChild(txtNode);
            newDesc.setAttribute("LanguageId", langId);
            newDesc.setAttribute(IMDIXMLFormat.getLinkXPath(3), urlToLink);
            newDesc.setAttribute("ArchiveHandle", urid);
            Node node = XPathAPI.selectSingleNode((Node)root, (String)query);
            if (node != null) {
                Node parent = node.getParentNode();
                parent.insertBefore(newDesc, node);
            } else {
                String pquery = IMDIXMLFormat.spec2XPath(parentDescSpec);
                if (pquery == null) {
                    return null;
                }
                if (IMDIXMLFormat.pointsToAttribute(pquery)) {
                    iedit.SEPi("Spec does not point to a valid location to add an Info File: " + pquery);
                    return null;
                }
                Node parent = XPathAPI.selectSingleNode((Node)root, (String)pquery);
                Node md = XPathAPI.selectSingleNode((Node)root, (String)"//MDGroup");
                parent.insertBefore(newDesc, md);
            }
            IMDIXMLFormat.addDomIds(doc, newDesc);
            IMDILink result = new IMDILink(IMDIXMLFormat.generateSpecFromNode(newDesc), IMDIXMLFormat.getDomId(newDesc), 3, curl);
            if (result == null) {
                iedit.SEPe("error creating IMDI Link for info file, newDesc=" + newDesc + ", curl=" + curl);
                return null;
            }
            result.setLanguageId(langId);
            result.setURID(urid);
            result.setValue(descText);
            result.setLinkDefinition(urlToLink);
            return result;
        }
        catch (TransformerException te) {
            iedit.SEPe("TransformerException while adding Info File: " + te.getMessage());
        }
        catch (DOMException de) {
            iedit.SEPe("DOMException while adding Info File: " + de.getMessage());
        }
        return null;
    }
}

