/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.imdi.api;

import nl.mpi.corpusstructure.ArchiveObjectsDB;
import nl.mpi.corpusstructure.NodeIdUtils;
import nl.mpi.corpusstructure.UnknownNodeException;
import nl.mpi.imdi.api.IMDIElement;
import nl.mpi.util.OurURL;

public class IMDILink
extends IMDIElement {
    private static int accessContext = 1;
    private static ArchiveObjectsDB resolver = null;
    private static boolean hdlToNodeId = true;
    private OurURL url;
    private String urid = null;
    private int nodeType;
    private String type = null;
    private String format = null;
    private String languageId = null;
    private String linkName = null;
    private String linkDefinition = null;

    public static void setResolver(ArchiveObjectsDB res, int context, boolean hton) {
        if (resolver != null) {
            resolver.close();
        }
        resolver = res;
        accessContext = context;
        hdlToNodeId = hton;
    }

    public static boolean hasResolver() {
        return resolver != null && resolver.getStatus();
    }

    public IMDILink(String spec, String domId, int nodeType, OurURL url) {
        super(spec, domId);
        this.nodeType = nodeType;
        this.url = url;
    }

    public int getNodeType() {
        return this.nodeType;
    }

    public void setURID(String u) {
        this.urid = u;
    }

    public String getURID() {
        return this.urid;
    }

    public void setURL(OurURL u) {
        this.url = u;
    }

    public OurURL getURL() {
        if (this.url == null && this.urid != null && IMDILink.hasResolver()) {
            try {
                String objectId = this.urid;
                if (hdlToNodeId) {
                    objectId = NodeIdUtils.handleToNodeId((String)this.urid, (String)resolver.getArchiveRoots().getHandlePrefix());
                }
                return resolver.getObjectURL(objectId, accessContext);
            }
            catch (UnknownNodeException une) {
                System.err.println("Cannot resolve URID: " + this.urid);
            }
        }
        return this.url;
    }

    public OurURL getRawURL() {
        return this.url;
    }

    public boolean setURIDfromURL() {
        String myURID = null;
        if (!IMDILink.hasResolver() || this.url == null) {
            return false;
        }
        myURID = resolver.getObjectId(this.url);
        if (myURID == null) {
            return false;
        }
        if (hdlToNodeId) {
            try {
                myURID = "hdl:" + NodeIdUtils.nodeIdToHandle((String)myURID, (String)resolver.getArchiveRoots().getHandlePrefix());
            }
            catch (UnknownNodeException une) {
                return false;
            }
        } else if (!myURID.startsWith("hdl:")) {
            myURID = "hdl:" + myURID;
        }
        this.urid = myURID;
        return true;
    }

    public void setLinkName(String cLinkName) {
        this.linkName = cLinkName;
    }

    public String getLinkName() {
        return this.linkName;
    }

    public void setLinkDefinition(String linkDef) {
        this.linkDefinition = linkDef;
    }

    public String getLinkDefinition() {
        return this.linkDefinition;
    }

    public void setType(String t) {
        this.type = t;
    }

    public String getType() {
        return this.type;
    }

    public void setFormat(String f) {
        this.format = f;
    }

    public String getFormat() {
        return this.format;
    }

    public String getLanguageId() {
        return this.languageId;
    }

    public void setLanguageId(String l) {
        this.languageId = l;
    }
}

